/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.List;
import org.apache.avro.SchemaRefWriter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.spf4j.maven.Registerer;

@SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
public abstract class SchemaMojoBase
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject mavenProject;
    @Parameter(name="dependenciesDirectory", defaultValue="${project.build.directory}/schema-dependencies", readonly=true)
    protected File dependenciesDirectory;
    @Parameter(name="sourceDirectory", defaultValue="${basedir}/src/main/avro")
    protected File sourceDirectory;
    @Parameter(name="generatedJavaTarget", defaultValue="${project.build.directory}/generated-sources/avro")
    protected File generatedJavaTarget;
    @Parameter(name="generatedAvscTarget", defaultValue="${project.build.directory}/generated-sources/avsc")
    protected File generatedAvscTarget;
    @Parameter(name="target", defaultValue="${project.build.directory}")
    protected File target;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession mavenSession;
    @Parameter(name="useSchemaReferencesForAvsc", defaultValue="false")
    protected boolean useSchemaReferencesForAvsc = false;
    @Parameter(name="schemaArtifactClassifier", defaultValue="avsc")
    protected String schemaArtifactClassifier = "avsc";
    @Parameter(name="schemaArtifactExtension", defaultValue="jar")
    protected String schemaArtifactExtension = "jar";
    @Component
    protected RepositorySystem repoSystem;

    public final RepositorySystem getRepoSystem() {
        return this.repoSystem;
    }

    public final MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public final File getGeneratedAvscTarget() {
        return this.generatedAvscTarget;
    }

    public final File getTarget() {
        return this.target;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.useSchemaReferencesForAvsc && SchemaRefWriter.isSchemaRefsSupported()) {
            Registerer.register((RepositorySystem)this.repoSystem, (RepositorySystemSession)this.getMavenSession().getRepositorySession(), (List)this.mavenProject.getRemoteProjectRepositories(), (String)this.schemaArtifactClassifier, (String)this.schemaArtifactExtension);
        }
    }

    public String toString() {
        return "SchemaMojoBase{dependenciesDirectory=" + this.dependenciesDirectory + ", sourceDirectory=" + this.sourceDirectory + ", generatedJavaTarget=" + this.generatedJavaTarget + ", generatedAvscTarget=" + this.generatedAvscTarget + ", target=" + this.target + '}';
    }
}

