/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.spf4j.io.compress.Compress;
import org.spf4j.maven.plugin.avro.avscp.SchemaMojoBase;

@Mojo(name="avro-package", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public final class SchemaPackageMojo
extends SchemaMojoBase {
    public String[] getSourceFiles() {
        FileSetManager fsm = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(this.sourceDirectory.getAbsolutePath());
        fs.addInclude("**/*.avsc");
        fs.addInclude("**/*.avpr");
        fs.addInclude("**/*.avdl");
        fs.setFollowSymlinks(false);
        return fsm.getIncludedFiles(fs);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        Log logger = this.getLog();
        logger.info((CharSequence)"Packaging schemas");
        Path avsc = this.target.toPath().resolve(this.mavenProject.getArtifactId() + '-' + this.mavenProject.getVersion() + '-' + "avsc." + this.schemaArtifactExtension);
        Path sourcePath = this.sourceDirectory.toPath();
        try {
            if (Files.notExists(sourcePath, new LinkOption[0])) {
                return;
            }
            Compress.zip((Path)this.generatedAvscTarget.toPath(), (Path)avsc);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot package schemas and sources from " + this.generatedAvscTarget, (Exception)ex);
        }
        DefaultArtifact schemas = new DefaultArtifact(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), "compile", this.schemaArtifactExtension, this.schemaArtifactClassifier, (ArtifactHandler)new DefaultArtifactHandler(this.schemaArtifactExtension));
        schemas.setFile(avsc.toFile());
        logger.debug((CharSequence)("Attaching " + schemas + " from " + avsc));
        this.mavenProject.getAttachedArtifacts().add(schemas);
        Path sources = this.target.toPath().resolve(this.mavenProject.getArtifactId() + '-' + this.mavenProject.getVersion() + '-' + "avroSources.jar");
        try {
            Compress.zip((Path)sourcePath, (Path)sources);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot package sources from " + this.sourceDirectory, (Exception)ex);
        }
        DefaultArtifact avroSources = new DefaultArtifact(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), "compile", "jar", "avroSources", (ArtifactHandler)new DefaultArtifactHandler("jar"));
        avroSources.setFile(sources.toFile());
        this.mavenProject.getAttachedArtifacts().add(avroSources);
    }

    @Override
    public String toString() {
        return "SchemaPackageMojo{schemaArtifactClassifier=" + this.schemaArtifactClassifier + ", " + super.toString() + '}';
    }
}

