/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.maven.plugin.avro.avscp.validation.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.maven.plugin.MojoExecutionException;
import org.spf4j.avro.schema.SchemaVisitor;
import org.spf4j.avro.schema.SchemaVisitorAction;
import org.spf4j.avro.schema.Schemas;
import org.spf4j.io.Csv;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.maven.plugin.avro.avscp.ValidatorMojo;
import org.spf4j.maven.plugin.avro.avscp.validation.Validator;
import org.spf4j.maven.plugin.avro.avscp.validation.Validators;

public final class SchemaNamesValidator
implements Validator<Schema> {
    @Override
    public String getName() {
        return "namesValidator";
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"AI_ANNOTATION_ISSUES_NEEDS_NULLABLE"})
    public Validator.Result validate(Schema schema, ValidatorMojo mojo) throws MojoExecutionException, IOException {
        Map<String, String> cfg = mojo.getValidatorConfigs();
        try {
            TreeSet<String> validTypeNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            validTypeNames.addAll(Csv.readRow((String)cfg.getOrDefault("validTypeNames", "")));
            TreeSet<String> invalidTypeNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            invalidTypeNames.addAll(Csv.readRow((String)cfg.getOrDefault("invalidTypeNames", "")));
            TreeSet<String> validFieldNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            validFieldNames.addAll(Csv.readRow((String)cfg.getOrDefault("validFieldNames", "x,y,z")));
            TreeSet<String> invalidFieldNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            invalidFieldNames.addAll(Csv.readRow((String)cfg.getOrDefault("invalidFieldNames", "")));
            return (Validator.Result)Schemas.visit((Schema)schema, (SchemaVisitor)new NamesValidatorVisitor(Integer.parseInt(cfg.getOrDefault("minNameSize", "3")), validTypeNames, invalidTypeNames, validFieldNames, invalidFieldNames, Boolean.parseBoolean(cfg.getOrDefault("camelCase", "true")), schema));
        }
        catch (CsvParseException ex) {
            throw new MojoExecutionException("Configuration issue with " + this.getName() + ", cfg = " + cfg, (Exception)((Object)ex));
        }
    }

    @Override
    public Class<Schema> getValidationInput() {
        return Schema.class;
    }

    private static class NamesValidatorVisitor
    implements SchemaVisitor<Validator.Result> {
        private final boolean camelCase;
        private final int minNameSize;
        private final Set<String> validTypeNames;
        private final Set<String> invalidTypeNames;
        private final Set<String> validFieldNames;
        private final Set<String> invalidFieldNames;
        private final List<String> issues = new ArrayList<String>(4);
        private final Schema root;

        NamesValidatorVisitor(int minNameSize, Set<String> validTypeNames, Set<String> invalidTypeNames, Set<String> validFieldNames, Set<String> invalidFieldNames, boolean camelCase, Schema root) {
            this.minNameSize = minNameSize;
            this.validTypeNames = validTypeNames;
            this.validFieldNames = validFieldNames;
            this.invalidTypeNames = invalidTypeNames;
            this.invalidFieldNames = invalidFieldNames;
            this.root = root;
            this.camelCase = camelCase;
        }

        private void validateTypeName(String name) {
            if (this.validTypeNames.contains(name)) {
                return;
            }
            if (this.invalidTypeNames.contains(name)) {
                this.issues.add("Invalid type name: " + name);
            }
            if (name.length() < this.minNameSize) {
                this.issues.add("Invalid type name, too short: " + name);
            }
            if (this.camelCase && name.contains("_")) {
                this.issues.add("Invalid type name, use camel case: " + name);
            }
        }

        private void validateFieldName(String schemaName, String name) {
            if (this.validFieldNames.contains(name)) {
                return;
            }
            if (this.invalidFieldNames.contains(name)) {
                this.issues.add("Invalid field name: " + name + " in " + schemaName);
            }
            if (name.length() < this.minNameSize) {
                this.issues.add("Invalid field name, too short: " + name + " in " + schemaName);
            }
            if (this.camelCase && name.contains("_")) {
                this.issues.add("Invalid field name, use camel case: " + name + " in " + schemaName);
            }
        }

        public SchemaVisitorAction visitTerminal(Schema schema) {
            switch (schema.getType()) {
                case ENUM: 
                case FIXED: {
                    this.validateTypeName(schema.getName());
                    break;
                }
            }
            return SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitorAction visitNonTerminal(Schema schema) {
            if (schema.getType() == Schema.Type.RECORD) {
                if (Validators.skipValidator(schema, "namesValidator")) {
                    return SchemaVisitorAction.CONTINUE;
                }
                String name = schema.getName();
                this.validateTypeName(name);
                for (Schema.Field field : schema.getFields()) {
                    this.validateFieldName(name, field.name());
                }
            }
            return SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitorAction afterVisitNonTerminal(Schema nonTerminal) {
            return SchemaVisitorAction.CONTINUE;
        }

        @Nonnull
        public Validator.Result get() {
            return this.issues.isEmpty() ? Validator.Result.valid() : Validator.Result.failed("Schema " + this.root.getFullName() + " naming issues:\n" + String.join((CharSequence)"\n", this.issues));
        }
    }
}

