/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.spf4j.io.AppendableWriter;
import org.spf4j.recyclable.impl.ArraySuppliers;

public final class Streams {
    private Streams() {
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        return Streams.copy(is, os, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream is, OutputStream os, int buffSize) throws IOException {
        if (buffSize < 2) {
            int val;
            long count = 0L;
            while ((val = is.read()) >= 0) {
                os.write(val);
                ++count;
            }
            return count;
        }
        long total = 0L;
        byte[] buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(buffSize);
        try {
            boolean done = false;
            long bytesCopiedSinceLastFlush = 0L;
            while (true) {
                int nrRead;
                if (is.available() > 0) {
                    nrRead = is.read(buffer, 0, buffSize);
                    if (nrRead < 0) {
                        done = true;
                    } else {
                        os.write(buffer, 0, nrRead);
                        total += (long)nrRead;
                        bytesCopiedSinceLastFlush += (long)nrRead;
                        continue;
                    }
                }
                if (bytesCopiedSinceLastFlush > 0L) {
                    os.flush();
                    bytesCopiedSinceLastFlush = 0L;
                }
                if (done) {
                    break;
                }
                nrRead = is.read(buffer, 0, buffSize);
                if (nrRead < 0) {
                    break;
                }
                os.write(buffer, 0, nrRead);
                total += (long)nrRead;
                bytesCopiedSinceLastFlush += (long)nrRead;
            }
        }
        finally {
            ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
        }
        return total;
    }

    public static Writer asWriter(Appendable appendable) {
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }
}

