/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.compress;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.io.BufferedInputStream;
import org.spf4j.io.Streams;
import org.spf4j.recyclable.impl.ArraySuppliers;

@ParametersAreNonnullByDefault
@Beta
@SuppressFBWarnings(value={"AFBR_ABNORMAL_FINALLY_BLOCK_RETURN"})
public final class Compress {
    private Compress() {
    }

    @Nonnull
    public static Path zip(Path fileOrFolderToCompress) throws IOException {
        Path parent = fileOrFolderToCompress.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Not a file: " + fileOrFolderToCompress);
        }
        Path destFile = parent.resolve(fileOrFolderToCompress.getFileName() + ".zip");
        Compress.zip(fileOrFolderToCompress, destFile);
        return destFile;
    }

    @Nonnull
    public static void zip(Path fileOrFolderToCompress, Path destFile) throws IOException {
        Compress.zip(fileOrFolderToCompress, destFile, p -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static void zip(Path fileOrFolderToCompress, Path destFile, Predicate<Path> filter) throws IOException {
        Path parent = destFile.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Parent is null for: " + fileOrFolderToCompress);
        }
        Path tmpFile = Files.createTempFile(parent, ".", "tmp", new FileAttribute[0]);
        try {
            Path relativePath = Files.isDirectory(fileOrFolderToCompress, new LinkOption[0]) ? fileOrFolderToCompress : fileOrFolderToCompress.getParent();
            try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));
                 ZipOutputStream zos = new ZipOutputStream((OutputStream)fos, StandardCharsets.UTF_8);
                 Stream<Path> ws = Files.walk(fileOrFolderToCompress, new FileVisitOption[0]);){
                ws.forEach(path -> {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        return;
                    }
                    if (!filter.test((Path)path)) {
                        return;
                    }
                    String fileName = relativePath.relativize((Path)path).toString();
                    try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]), 8192, ArraySuppliers.Bytes.TL_SUPPLIER);){
                        ZipEntry ze = new ZipEntry(fileName);
                        zos.putNextEntry(ze);
                        Streams.copy(in, zos);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException("Error compressing " + path, ex);
                    }
                });
            }
            Files.move(tmpFile, destFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileAtomic(Path source, Path destinationFile) throws IOException {
        Path parent = destinationFile.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Destination " + destinationFile + " is not a file");
        }
        Path tmpFile = Files.createTempFile(parent, ".", null, new FileAttribute[0]);
        try {
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]), 8192, ArraySuppliers.Bytes.TL_SUPPLIER);
                 BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));){
                Streams.copy(in, os);
            }
            Files.move(tmpFile, destinationFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    @Nonnull
    public static List<Path> unzip(Path zipFile) throws IOException {
        Path parent = zipFile.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("File " + zipFile + " cannot be unzipped to null parent folder");
        }
        return Compress.unzip(zipFile, parent);
    }

    @Nonnull
    public static List<Path> unzip(Path zipFile, Path destinationDirectory) throws IOException {
        return Compress.unzip(zipFile, destinationDirectory, p -> true);
    }

    @Nonnull
    public static List<Path> unzip(Path zipFile, Path destinationDirectory, final Predicate<Path> filter) throws IOException {
        if (!Files.exists(destinationDirectory, new LinkOption[0])) {
            Files.createDirectories(destinationDirectory, new FileAttribute[0]);
        }
        if (!Files.isDirectory(destinationDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Destination " + destinationDirectory + " must be a directory");
        }
        final ArrayList<Path> response = new ArrayList<Path>();
        URI zipUri = URI.create("jar:" + zipFile.toUri().toURL());
        try (FileSystem zipFs = FileSystems.newFileSystem(zipUri, Collections.emptyMap());){
            for (final Path root : zipFs.getRootDirectories()) {
                final Path dest = destinationDirectory.resolve(root.toString().substring(1));
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!filter.test(file)) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path destination = dest.resolve(root.relativize(file).toString());
                        Compress.copyFileAtomic(file, destination);
                        response.add(destination);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String dirStr = dir.toString();
                        Path np = dest.resolve(dirStr.substring(1));
                        Files.createDirectories(np, new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException | RuntimeException ex) {
            for (Path path : response) {
                try {
                    Files.delete(path);
                }
                catch (IOException | RuntimeException ex2) {
                    ex.addSuppressed(ex2);
                }
            }
            throw ex;
        }
        return response;
    }
}

