/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.spf4j.recyclable.SizedRecyclingSupplier;
import org.spf4j.recyclable.impl.ArraySuppliers;

@CleanupObligation
@SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
public final class BufferedInputStream
extends FilterInputStream {
    private static int defaultBufferSize = 8192;
    private static final AtomicReferenceFieldUpdater<BufferedInputStream, byte[]> BUF_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BufferedInputStream.class, byte[].class, "buf");
    private volatile byte[] buf;
    private int count;
    private int pos;
    private int markpos = -1;
    private int marklimit;
    private final SizedRecyclingSupplier<byte[]> bufferProvider;

    private InputStream getInIfOpen() throws IOException {
        InputStream input = this.in;
        if (input == null) {
            throw new IOException("Stream closed " + this.in);
        }
        return input;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] buffer = this.buf;
        if (buffer == null) {
            throw new IOException("Stream closed " + this.in);
        }
        return buffer;
    }

    public BufferedInputStream(InputStream in) {
        this(in, defaultBufferSize);
    }

    public BufferedInputStream(InputStream in, int size) {
        this(in, size, ArraySuppliers.Bytes.JAVA_NEW);
    }

    public BufferedInputStream(InputStream in, int size, SizedRecyclingSupplier<byte[]> bufferProvider) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0 : " + size);
        }
        this.bufferProvider = bufferProvider;
        this.buf = bufferProvider.get(size);
    }

    private void fill() throws IOException {
        byte[] buffer = this.getBufIfOpen();
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= buffer.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(buffer, this.markpos, buffer, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (buffer.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                byte[] nbuf;
                int nsz = this.pos * 2;
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                if (!BUF_UPDATER.compareAndSet(this, buffer, nbuf = this.bufferProvider.get(nsz))) {
                    this.bufferProvider.recycle(nbuf);
                    throw new IOException("Stream closed " + this.in);
                }
                System.arraycopy(buffer, 0, nbuf, 0, this.pos);
                this.bufferProvider.recycle(buffer);
                buffer = nbuf;
            }
        }
        this.count = this.pos;
        int n = this.getInIfOpen().read(buffer, this.pos, buffer.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.getBufIfOpen().length && this.markpos < 0) {
                return this.getInIfOpen().read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.getBufIfOpen(), this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        InputStream input;
        this.getBufIfOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            int nread;
            if ((nread = this.read1(b, off + n, len - n)) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while ((input = this.in) == null || input.available() > 0);
        return n;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        this.getBufIfOpen();
        if (n <= 0L) {
            return 0L;
        }
        long avail = (long)this.count - (long)this.pos;
        if (avail <= 0L) {
            if (this.markpos < 0) {
                return this.getInIfOpen().skip(n);
            }
            this.fill();
            avail = (long)this.count - (long)this.pos;
            if (avail <= 0L) {
                return 0L;
            }
        }
        long skipped = avail < n ? avail : n;
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    @Override
    public synchronized int available() throws IOException {
        return this.getInIfOpen().available() + (this.count - this.pos);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getBufIfOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark" + this.markpos);
        }
        this.pos = this.markpos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        block2: {
            byte[] buffer;
            do {
                buffer = this.buf;
                if (this.buf == null) break block2;
            } while (!BUF_UPDATER.compareAndSet(this, buffer, null));
            this.bufferProvider.recycle(buffer);
            InputStream input = this.in;
            this.in = null;
            if (input != null) {
                input.close();
            }
            return;
        }
    }

    public String toString() {
        return "BufferedInputStream{buf=" + (this.buf != null ? Base64.getEncoder().encodeToString(this.buf) : "null") + ", count=" + this.count + ", pos=" + this.pos + ", markpos=" + this.markpos + ", marklimit=" + this.marklimit + ", bufferProvider=" + this.bufferProvider + '}';
    }
}

