/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.spf4j.recyclable.NonValidatingRecyclingSupplier;

public final class ThreadLocalRecyclingSupplier<T>
implements NonValidatingRecyclingSupplier<T> {
    private final Supplier<T> supplier;
    private final ThreadLocal<T> threadLocal;

    public ThreadLocalRecyclingSupplier(final Supplier<T> supplier) {
        this.supplier = supplier;
        this.threadLocal = new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                return supplier.get();
            }
        };
    }

    @Override
    @Nonnull
    public T get() {
        T obj = this.threadLocal.get();
        if (obj == null) {
            return this.supplier.get();
        }
        this.threadLocal.set(null);
        return obj;
    }

    @Override
    public void recycle(T object) {
        this.threadLocal.set(object);
    }

    public String toString() {
        return "ThreadLocalRecyclingSupplier{supplier=" + this.supplier + ", threadLocal=" + this.threadLocal + '}';
    }
}

