/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.spf4j.io.AppendableWriter;
import org.spf4j.recyclable.impl.ArraySuppliers;

public final class Streams {
    private Streams() {
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        return Streams.copy(is, os, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream is, OutputStream os, int buffSize) throws IOException {
        if (buffSize < 2) {
            int val;
            long count = 0L;
            while ((val = is.read()) >= 0) {
                os.write(val);
                ++count;
            }
            return count;
        }
        long total = 0L;
        byte[] buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(buffSize);
        try {
            boolean done = false;
            long bytesCopiedSinceLastFlush = 0L;
            while (true) {
                int nrRead;
                if (is.available() > 0) {
                    nrRead = is.read(buffer, 0, buffSize);
                    if (nrRead < 0) {
                        done = true;
                    } else {
                        os.write(buffer, 0, nrRead);
                        total += (long)nrRead;
                        bytesCopiedSinceLastFlush += (long)nrRead;
                        continue;
                    }
                }
                if (bytesCopiedSinceLastFlush > 0L) {
                    os.flush();
                    bytesCopiedSinceLastFlush = 0L;
                }
                if (done) {
                    break;
                }
                nrRead = is.read(buffer, 0, buffSize);
                if (nrRead < 0) {
                    break;
                }
                os.write(buffer, 0, nrRead);
                total += (long)nrRead;
                bytesCopiedSinceLastFlush += (long)nrRead;
            }
        }
        finally {
            ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static long copy(InputStream is, OutputStream os, int buffSize, long maxBytes) throws IOException {
        block9: {
            if (buffSize < 2) {
                for (count = 0L; count < maxBytes && (val = is.read()) >= 0; ++count) {
                    os.write(val);
                }
                return count;
            }
            count = 0L;
            buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(buffSize);
            try {
                done = false;
                bytesCopiedSinceLastFlush = 0L;
                do lbl-1000:
                // 3 sources

                {
                    block10: {
                        block11: {
                            if (is.available() <= 0) break block10;
                            left = maxBytes - count;
                            toRead = Math.min(buffSize, left > 0x7FFFFFFFL ? 0x7FFFFFFF : (int)left);
                            nrRead = is.read(buffer, 0, toRead);
                            if (nrRead >= 0) break block11;
                            done = true;
                            break block10;
                        }
                        os.write(buffer, 0, nrRead);
                        bytesCopiedSinceLastFlush += (long)nrRead;
                        if ((count += (long)nrRead) < maxBytes) ** GOTO lbl-1000
                        done = true;
                    }
                    if (bytesCopiedSinceLastFlush > 0L) {
                        os.flush();
                        bytesCopiedSinceLastFlush = 0L;
                    }
                    if (done) {
                        break block9;
                    }
                    left = maxBytes - count;
                    toRead = Math.min(buffSize, left > 0x7FFFFFFFL ? 0x7FFFFFFF : (int)left);
                    nrRead = is.read(buffer, 0, toRead);
                    if (nrRead < 0) {
                        break block9;
                    }
                    os.write(buffer, 0, nrRead);
                    bytesCopiedSinceLastFlush += (long)nrRead;
                } while ((count += (long)nrRead) < maxBytes);
                done = true;
            }
            finally {
                ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
            }
        }
        return count;
    }

    public static Writer asWriter(Appendable appendable) {
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }
}

