/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base.asm;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.spf4j.base.asm.Invocation;
import org.spf4j.base.asm.TypeUtils;

class MethodInvocationClassVisitor
extends EmptyVisitor {
    private final Collection<Invocation> addCaleesTo;
    private final Map<String, Method> methodStrings;
    private String className;
    private String source;

    public MethodInvocationClassVisitor(Collection addCaleesTo, Set<Method> methods) {
        this.addCaleesTo = addCaleesTo;
        this.methodStrings = new HashMap<String, Method>(methods.size());
        for (Method m : methods) {
            this.methodStrings.put(TypeUtils.toString(m), m);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
    }

    public void visitSource(String psource, String debug) {
        this.source = psource;
    }

    public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
        return new EmptyVisitor(){
            private int lineNumber;
            private final Deque<Object> stack = new ArrayDeque<Object>();
            {
                Type[] argumentTypes = Type.getArgumentTypes((String)methodDesc);
                this.stack.addAll(Arrays.asList(argumentTypes));
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                Method invokedMethod = (Method)MethodInvocationClassVisitor.this.methodStrings.get(owner + '/' + name + desc);
                boolean isCallingtarget = invokedMethod != null;
                Type[] parameterTypes = Type.getArgumentTypes((String)desc);
                Object[] parameters = new Object[parameterTypes.length];
                for (int i = parameterTypes.length - 1; i >= 0; --i) {
                    parameters[i] = this.stack.isEmpty() ? "UNKNOWN" : this.stack.pop();
                }
                if (isCallingtarget) {
                    MethodInvocationClassVisitor.this.addCaleesTo.add(new Invocation(MethodInvocationClassVisitor.this.className, methodName, methodDesc, parameters, MethodInvocationClassVisitor.this.source, this.lineNumber, invokedMethod));
                }
            }

            public void visitLdcInsn(Object o) {
                this.stack.push(o);
            }

            public void visitLineNumber(int line, Label start) {
                this.lineNumber = line;
            }
        };
    }
}

