/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base.asm;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.spf4j.base.asm.Invocation;
import org.spf4j.base.asm.MethodInvocationClassVisitor;

public final class Scanner {
    private Scanner() {
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static List<Invocation> findUsages(Supplier<InputStream> classSupplier, Set<Method> invokedMethods) throws IOException {
        try (InputStream is = (InputStream)classSupplier.get();){
            ClassReader reader = new ClassReader(is);
            ArrayList<Invocation> result = new ArrayList<Invocation>();
            reader.accept((ClassVisitor)new MethodInvocationClassVisitor(result, invokedMethods), 0);
            ArrayList<Invocation> arrayList = result;
            return arrayList;
        }
    }

    public static List<Invocation> findUsages(Class<?> clasz, Set<Method> invokedMethods) {
        return Scanner.findUsages(clasz.getClassLoader(), clasz.getName().replaceAll("\\.", "/") + ".class", invokedMethods);
    }

    public static List<Invocation> findUsages(final ClassLoader cl, final String claszResourcePath, Set<Method> invokedMethods) {
        Supplier<InputStream> supplier = new Supplier<InputStream>(){

            public InputStream get() {
                return new BufferedInputStream(cl.getResourceAsStream(claszResourcePath));
            }
        };
        try {
            return Scanner.findUsages(supplier, invokedMethods);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<Invocation> findUsages(String packageName, Set<Method> invokedMethods) throws IOException {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        ClassPath cp = ClassPath.from((ClassLoader)cl);
        ImmutableSet classes = cp.getAllClasses();
        ArrayList<Invocation> result = new ArrayList<Invocation>();
        for (ClassPath.ClassInfo info : classes) {
            if (!info.getName().startsWith(packageName)) continue;
            result.addAll(Scanner.findUsages(cl, info.getResourceName(), invokedMethods));
        }
        return result;
    }
}

