/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base.asm;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public final class Invocation {
    private final String caleeClassName;
    private final String caleeMethodName;
    private final String caleeMethodDesc;
    private final String caleeSource;
    private final int caleeLine;
    private final Object[] parameters;
    private final Method invokedMethod;

    public Invocation(String cName, String mName, String mDesc, Object[] parameters, String src, int ln, Method invokedMethod) {
        this.caleeClassName = cName;
        this.caleeMethodName = mName;
        this.caleeMethodDesc = mDesc;
        this.parameters = (Object[])parameters.clone();
        this.caleeSource = src;
        this.caleeLine = ln;
        this.invokedMethod = invokedMethod;
    }

    public String getCaleeClassName() {
        return this.caleeClassName;
    }

    public String getCaleeMethodName() {
        return this.caleeMethodName;
    }

    public String getCaleeMethodDesc() {
        return this.caleeMethodDesc;
    }

    public String getCaleeSource() {
        return this.caleeSource;
    }

    public int getCaleeLine() {
        return this.caleeLine;
    }

    public Method getInvokedMethod() {
        return this.invokedMethod;
    }

    public Object[] getParameters() {
        return (Object[])this.parameters.clone();
    }

    public String toString() {
        return "Invocation{caleeClassName=" + this.caleeClassName + ", caleeMethodName=" + this.caleeMethodName + ", caleeMethodDesc=" + this.caleeMethodDesc + ", caleeSource=" + this.caleeSource + ", caleeLine=" + this.caleeLine + ", parameters=" + Arrays.toString(this.parameters) + ", invokedMethod=" + this.invokedMethod + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.caleeClassName);
        return 97 * hash + Objects.hashCode(this.caleeMethodName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Invocation other = (Invocation)obj;
        if (this.caleeLine != other.caleeLine) {
            return false;
        }
        if (!Objects.equals(this.caleeClassName, other.caleeClassName)) {
            return false;
        }
        if (!Objects.equals(this.caleeMethodName, other.caleeMethodName)) {
            return false;
        }
        if (!Objects.equals(this.caleeMethodDesc, other.caleeMethodDesc)) {
            return false;
        }
        if (!Objects.equals(this.caleeSource, other.caleeSource)) {
            return false;
        }
        if (!Arrays.deepEquals(this.parameters, other.parameters)) {
            return false;
        }
        return Objects.equals(this.invokedMethod, other.invokedMethod);
    }
}

