/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spf4j.base.asm.Invocation;
import org.spf4j.base.asm.TypeUtils;
import org.spf4j.base.asm.UnknownValue;

class MethodInvocationClassVisitor
extends ClassVisitor {
    private final Collection<Invocation> addCaleesTo;
    private final Map<String, Method> methodStrings;
    private String className;
    private String source;

    MethodInvocationClassVisitor(Collection addCaleesTo, Set<Method> methods) {
        super(327680);
        this.addCaleesTo = addCaleesTo;
        this.methodStrings = new HashMap<String, Method>(methods.size());
        for (Method m : methods) {
            this.methodStrings.put(TypeUtils.toString(m), m);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
    }

    public void visitSource(String psource, String debug) {
        this.source = psource;
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        return new MethodVisitorImpl(327680, methodDesc, methodName);
    }

    public String toString() {
        return "MethodInvocationClassVisitor{addCaleesTo=" + this.addCaleesTo + ", methodStrings=" + this.methodStrings + ", className=" + this.className + ", source=" + this.source + '}';
    }

    private class MethodVisitorImpl
    extends MethodVisitor {
        private final String methodDesc;
        private final String methodName;
        private int lineNumber;
        private final Stack<Object> stack;

        MethodVisitorImpl(int api, String methodDesc, String methodName) {
            super(api);
            this.methodDesc = methodDesc;
            this.methodName = methodName;
            this.stack = new Stack();
            Type[] argumentTypes = Type.getArgumentTypes((String)methodDesc);
            for (int i = 0; i < argumentTypes.length; ++i) {
                this.stack.add(new UnknownValue(-1));
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Method invokedMethod = (Method)MethodInvocationClassVisitor.this.methodStrings.get(owner + '/' + name + desc);
            Type returnType = Type.getReturnType((String)desc);
            Type[] parameterTypes = Type.getArgumentTypes((String)desc);
            if (invokedMethod != null) {
                Object[] parameters = new Object[parameterTypes.length];
                for (int i = parameterTypes.length - 1; i >= 0; --i) {
                    if (this.stack.isEmpty()) {
                        throw new RuntimeException("Not enough params in stack for invocation of " + desc + " at " + MethodInvocationClassVisitor.this.className + '.' + this.methodName + '.' + this.lineNumber);
                    }
                    parameters[i] = this.stack.pop();
                }
                MethodInvocationClassVisitor.this.addCaleesTo.add(new Invocation(MethodInvocationClassVisitor.this.className, this.methodName, this.methodDesc, parameters, MethodInvocationClassVisitor.this.source, this.lineNumber, invokedMethod));
                if (opcode != 184 && !this.stack.isEmpty()) {
                    this.stack.pop();
                }
            } else {
                int length = parameterTypes.length;
                if (opcode != 184) {
                    ++length;
                }
                for (int i = 0; i < length; ++i) {
                    if (this.stack.isEmpty()) continue;
                    this.stack.pop();
                }
            }
            if (returnType != Type.VOID_TYPE) {
                this.stack.push(new UnknownValue(opcode));
            }
        }

        public void visitLdcInsn(Object o) {
            this.stack.push(o);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.stack.push(new UnknownValue(opcode));
        }

        @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "CC_CYCLOMATIC_COMPLEXITY"})
        public void visitInsn(int opcode) {
            Object pop1 = null;
            Object pop2 = null;
            switch (opcode) {
                case 3: {
                    this.stack.push(0);
                    break;
                }
                case 4: {
                    this.stack.push(1);
                    break;
                }
                case 5: {
                    this.stack.push(2);
                    break;
                }
                case 6: {
                    this.stack.push(3);
                    break;
                }
                case 7: {
                    this.stack.push(4);
                    break;
                }
                case 8: {
                    this.stack.push(5);
                    break;
                }
                case 2: {
                    this.stack.push(-1);
                    break;
                }
                case 9: {
                    this.stack.push(0L);
                    break;
                }
                case 10: {
                    this.stack.push(1L);
                    break;
                }
                case 11: {
                    this.stack.push(Float.valueOf(0.0f));
                    break;
                }
                case 12: {
                    this.stack.push(Float.valueOf(1.0f));
                    break;
                }
                case 13: {
                    this.stack.push(Float.valueOf(2.0f));
                    break;
                }
                case 14: {
                    this.stack.push(0.0);
                    break;
                }
                case 15: {
                    this.stack.push(1.0);
                    break;
                }
                case 1: {
                    this.stack.push(null);
                    break;
                }
                case 89: 
                case 92: {
                    Object pop = this.stack.peek();
                    this.stack.push(pop);
                    break;
                }
                case 90: 
                case 93: {
                    Object a1 = this.stack.peek();
                    Object b1 = this.stack.peek();
                    this.stack.push(a1);
                    this.stack.push(b1);
                    this.stack.push(a1);
                    break;
                }
                case 91: 
                case 94: {
                    Object a2 = this.stack.peek();
                    Object b2 = this.stack.peek();
                    Object c2 = this.stack.peek();
                    this.stack.push(a2);
                    this.stack.push(c2);
                    this.stack.push(b2);
                    this.stack.push(a2);
                    break;
                }
                case 108: {
                    pop1 = this.stack.pop();
                    pop2 = this.stack.pop();
                    try {
                        this.stack.push((Integer)pop2 / (Integer)pop1);
                    }
                    catch (RuntimeException ex) {
                        this.stack.push(new UnknownValue(opcode));
                    }
                    break;
                }
                case 104: {
                    pop1 = this.stack.pop();
                    pop2 = this.stack.pop();
                    try {
                        this.stack.push((Integer)pop2 * (Integer)pop1);
                    }
                    catch (RuntimeException ex) {
                        this.stack.push(new UnknownValue(opcode));
                    }
                    break;
                }
                case 96: {
                    pop1 = this.stack.pop();
                    pop2 = this.stack.pop();
                    try {
                        this.stack.push((Integer)pop2 + (Integer)pop1);
                    }
                    catch (RuntimeException ex) {
                        this.stack.push(new UnknownValue(opcode));
                    }
                    break;
                }
                case 100: {
                    pop1 = this.stack.pop();
                    pop2 = this.stack.pop();
                    try {
                        this.stack.push((Integer)pop2 - (Integer)pop1);
                    }
                    catch (RuntimeException ex) {
                        this.stack.push(new UnknownValue(opcode));
                    }
                    break;
                }
                case 109: {
                    pop1 = this.stack.pop();
                    pop2 = this.stack.pop();
                    try {
                        this.stack.push((Long)pop2 / (Long)pop1);
                    }
                    catch (RuntimeException ex) {
                        this.stack.push(new UnknownValue(opcode));
                    }
                    break;
                }
                case 105: {
                    pop1 = this.stack.pop();
                    pop2 = this.stack.pop();
                    try {
                        this.stack.push((Long)pop2 * (Long)pop1);
                    }
                    catch (RuntimeException ex) {
                        this.stack.push(new UnknownValue(opcode));
                    }
                    break;
                }
                case 97: {
                    pop1 = this.stack.pop();
                    pop2 = this.stack.pop();
                    try {
                        this.stack.push((Long)pop2 + (Long)pop1);
                    }
                    catch (RuntimeException ex) {
                        this.stack.push(new UnknownValue(opcode));
                    }
                    break;
                }
                case 101: {
                    pop1 = this.stack.pop();
                    pop2 = this.stack.pop();
                    try {
                        this.stack.push((Long)pop2 - (Long)pop1);
                    }
                    catch (RuntimeException ex) {
                        this.stack.push(new UnknownValue(opcode));
                    }
                    break;
                }
                default: {
                    this.stack.push(new UnknownValue(opcode));
                }
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            switch (opcode) {
                case 178: {
                    Field declaredField;
                    Class<?> clasz;
                    try {
                        clasz = Class.forName(owner.replace('/', '.'));
                    }
                    catch (ClassNotFoundException ex) {
                        this.stack.push(new UnknownValue(opcode));
                        break;
                    }
                    try {
                        declaredField = clasz.getDeclaredField(name);
                    }
                    catch (NoSuchFieldException | SecurityException ex) {
                        this.stack.push(new UnknownValue(opcode));
                        break;
                    }
                    if ((declaredField.getModifiers() & 0x10) == 16) {
                        Object value;
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                declaredField.setAccessible(true);
                                return null;
                            }
                        });
                        try {
                            value = declaredField.get(null);
                        }
                        catch (IllegalAccessException | IllegalArgumentException ex) {
                            this.stack.push(new UnknownValue(opcode));
                            break;
                        }
                        this.stack.push(value);
                        break;
                    }
                    this.stack.push(new UnknownValue(opcode));
                    break;
                }
                case 180: {
                    this.stack.push(new UnknownValue(opcode));
                    break;
                }
                case 179: 
                case 181: {
                    if (this.stack.isEmpty()) break;
                    this.stack.pop();
                    break;
                }
                default: {
                    throw new IllegalStateException(" Illegal opcode = " + opcode + " in context");
                }
            }
        }

        public void visitIntInsn(int opcode, int operand) {
            switch (opcode) {
                case 16: 
                case 17: {
                    this.stack.push(operand);
                    break;
                }
                default: {
                    this.stack.push(new UnknownValue(opcode));
                }
            }
        }

        public void visitVarInsn(int opcode, int var) {
            if (opcode >= 21 && opcode <= 45) {
                this.stack.push(new UnknownValue(opcode));
            } else if (opcode >= 54 && opcode <= 78) {
                if (!this.stack.isEmpty()) {
                    this.stack.pop();
                }
            } else {
                this.stack.push(new UnknownValue(opcode));
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.stack.push(new UnknownValue(197));
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            Type[] argumentTypes = Type.getArgumentTypes((String)desc);
            for (int i = 0; i < argumentTypes.length; ++i) {
                this.stack.pop();
            }
            Type returnType = Type.getReturnType((String)desc);
            if (returnType != Type.VOID_TYPE) {
                this.stack.push(new UnknownValue(186));
            }
        }

        public void visitLineNumber(int line, Label start) {
            this.lineNumber = line;
        }
    }
}

