/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayBuilder<T> {
    private T[] array;
    private int size;

    public ArrayBuilder(int initialSize, Class<T> elementType) {
        this.array = (Object[])Array.newInstance(elementType, initialSize);
        this.size = 0;
    }

    public void add(T element) {
        int sp1 = this.size + 1;
        this.ensureCapacity(sp1);
        this.array[this.size] = element;
        this.size = sp1;
    }

    public void clear() {
        Arrays.fill(this.array, 0, this.size, null);
        this.size = 0;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.array.length > 0) {
            this.expandCapacity(minCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = this.array.length + this.array.length >> 1;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.array = Arrays.copyOf(this.array, newCapacity);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public T[] getArray() {
        return this.array;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return "ArrayBuilder{array=" + Arrays.toString(this.array) + ", size=" + this.size + '}';
    }
}

