/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spf4j.base.IntAppender;
import org.spf4j.base.Strings;

public final class CharSequences {
    private CharSequences() {
    }

    public static int compareTo(@Nonnull CharSequence s, @Nonnull CharSequence t) {
        int sl = s.length();
        int tl = t.length();
        for (int i = 0; i < sl && i < tl; ++i) {
            char b;
            char a = s.charAt(i);
            int diff = a - (b = t.charAt(i));
            if (diff == 0) continue;
            return diff;
        }
        return sl - tl;
    }

    public static boolean equalsNullables(@Nullable CharSequence s, @Nullable CharSequence t) {
        if (s == null) {
            return null == t;
        }
        if (t == null) {
            return true;
        }
        return CharSequences.equals(s, t);
    }

    public static boolean equals(@Nonnull CharSequence s, @Nonnull CharSequence t) {
        int tl;
        int sl = s.length();
        if (sl != (tl = t.length())) {
            return false;
        }
        for (int i = 0; i < sl; ++i) {
            if (s.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int hashcode(@Nonnull CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).hashCode();
        }
        int h = 0;
        int len = cs.length();
        if (len > 0) {
            int off = 0;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + cs.charAt(off++);
            }
        }
        return h;
    }

    public static CharSequence subSequence(@Nonnull CharSequence seq, int startIdx, int endIdx) {
        if (startIdx == 0 && endIdx == seq.length()) {
            return seq;
        }
        if (startIdx >= endIdx) {
            return "";
        }
        return new SubSequence(seq, endIdx - startIdx, startIdx);
    }

    public static boolean endsWith(CharSequence qc, CharSequence with) {
        int l = qc.length();
        int start = l - with.length();
        if (start >= 0) {
            int i = start;
            int j = 0;
            while (i < l) {
                if (qc.charAt(i) != with.charAt(j)) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        return false;
    }

    public static Appendable lineNumbered(int startLineNr, Appendable appendable) throws IOException {
        return CharSequences.lineNumbered(startLineNr, appendable, IntAppender.CommentNumberAppender.INSTANCE);
    }

    public static Appendable lineNumbered(final int startLineNr, final Appendable appendable, final IntAppender ia) throws IOException {
        ia.append(startLineNr, appendable);
        return new Appendable(){
            private int lineNr;
            {
                this.lineNr = startLineNr + 1;
            }

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                return this.append(csq, 0, csq.length());
            }

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                int lastIdx = start;
                for (int i = start; i < end; ++i) {
                    if (csq.charAt(i) != '\n') continue;
                    int next = i + 1;
                    appendable.append(csq, lastIdx, next);
                    ia.append(this.lineNr++, appendable);
                    lastIdx = next;
                }
                if (lastIdx < end) {
                    appendable.append(csq, lastIdx, end);
                }
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                appendable.append(c);
                if (c == '\n') {
                    ia.append(this.lineNr++, appendable);
                }
                return this;
            }
        };
    }

    public static CharSequence toLineNumbered(int startLineNr, CharSequence source) {
        return CharSequences.toLineNumbered(startLineNr, source, IntAppender.CommentNumberAppender.INSTANCE);
    }

    public static CharSequence toLineNumbered(int startLineNr, CharSequence source, IntAppender ia) {
        int length = source.length();
        StringBuilder destination = new StringBuilder(length + 6 * length / 80);
        try {
            CharSequences.lineNumbered(startLineNr, destination, ia).append(source);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return destination;
    }

    public static int parseInt(CharSequence s) {
        return CharSequences.parseInt(s, 10);
    }

    public static int parseInt(CharSequence cs, int radix) {
        if (cs == null) {
            throw new NumberFormatException("cs is null for radix = " + radix);
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        int result = 0;
        boolean negative = false;
        int len = cs.length();
        if (len > 0) {
            int i = 0;
            int limit = -2147483647;
            char firstChar = cs.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if (len == 1) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                ++i;
            }
            int multmin = limit / radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(cs.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
        }
        return negative ? result : -result;
    }

    public static long parseLong(CharSequence cs) {
        return CharSequences.parseLong(cs, 10);
    }

    public static long parseLong(CharSequence cs, int radix) {
        if (cs == null) {
            throw new NumberFormatException("cs is null for radix = " + radix);
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int len = cs.length();
        if (len > 0) {
            int i = 0;
            long limit = -9223372036854775807L;
            char firstChar = cs.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if (len == 1) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(cs.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException("For input char sequence: \"" + cs + '\"');
        }
        return negative ? result : -result;
    }

    private static final class SubSequence
    implements CharSequence {
        private final CharSequence underlyingSequence;
        private final int length;
        private final int startIdx;

        SubSequence(CharSequence underlyingSequence, int length, int startIdx) {
            this.underlyingSequence = underlyingSequence;
            this.length = length;
            this.startIdx = startIdx;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.underlyingSequence.charAt(this.startIdx + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return CharSequences.subSequence(this.underlyingSequence, this.startIdx + start, this.startIdx + end);
        }

        @Override
        public String toString() {
            char[] chars = new char[this.length];
            int idx = this.startIdx;
            int i = 0;
            while (i < this.length) {
                chars[i] = this.underlyingSequence.charAt(idx);
                ++i;
                ++idx;
            }
            return Strings.wrap(chars);
        }
    }
}

