/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.IntSequence;

public final class IntMath {
    private IntMath() {
    }

    public static int closestPowerOf2(int number) {
        return number == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(number - 1);
    }

    public static int closestPowerOf2Number(int number) {
        return number == 0 ? 0 : 1 << 32 - Integer.numberOfLeadingZeros(number - 1);
    }

    @NotThreadSafe
    public static final class XorShift128
    implements IntSequence {
        private int x = System.identityHashCode(this);
        private int y = -938745813;
        private int z = 452465366;
        private int w = 1343246171;

        @Override
        public int nextInt() {
            int t = this.x ^ this.x << 15;
            this.x = this.y;
            this.y = this.z;
            this.z = this.w;
            this.w = this.w ^ this.w >>> 21 ^ (t ^ t >>> 4);
            return this.w;
        }
    }

    @Deprecated
    @ThreadSafe
    public static final class XorShift32ThreadSafe
    implements IntSequence {
        private final ThreadLocal<XorShift32> rnd = new ThreadLocalRandom();

        @Override
        public int nextInt() {
            return this.rnd.get().nextInt();
        }

        private static class ThreadLocalRandom
        extends ThreadLocal<XorShift32> {
            private ThreadLocalRandom() {
            }

            @Override
            protected XorShift32 initialValue() {
                return new XorShift32();
            }
        }

        public static final class Singleton {
            public static final XorShift32ThreadSafe INSTANCE = new XorShift32ThreadSafe();
        }
    }

    @NotThreadSafe
    public static final class XorShift32
    implements IntSequence {
        private int x = System.identityHashCode(this);

        @Override
        public int nextInt() {
            this.x ^= this.x << 6;
            this.x ^= this.x >>> 21;
            return this.x ^ this.x << 7;
        }
    }
}

