/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Objects;
import org.spf4j.base.CharSequenceTranslator;

@SuppressWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
public final class LookupTranslator
extends CharSequenceTranslator {
    private final HashMap<String, CharSequence> lookupMap = new HashMap();
    private final int shortest;
    private final int longest;

    public LookupTranslator(CharSequence[] ... lookup) {
        int ashortest = Integer.MAX_VALUE;
        int alongest = 0;
        if (lookup != null) {
            for (CharSequence[] seq : lookup) {
                this.lookupMap.put(seq[0].toString(), seq[1]);
                int sz = seq[0].length();
                if (sz < ashortest) {
                    ashortest = sz;
                }
                if (sz <= alongest) continue;
                alongest = sz;
            }
        }
        this.shortest = ashortest;
        this.longest = alongest;
    }

    @Override
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        int max = this.longest;
        int l = input.length();
        if (index + this.longest > l) {
            max = l - index;
        }
        for (int i = max; i >= this.shortest; --i) {
            CharSequence subSeq = input.subSequence(index, index + i);
            CharSequence result = this.lookupMap.get(subSeq.toString());
            if (result == null) continue;
            out.write(result.toString());
            return i;
        }
        return 0;
    }

    public String toString() {
        return "LookupTranslator{lookupMap=" + this.lookupMap + ", shortest=" + this.shortest + ", longest=" + this.longest + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.lookupMap);
        hash = 73 * hash + this.shortest;
        return 73 * hash + this.longest;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LookupTranslator other = (LookupTranslator)obj;
        if (this.shortest != other.shortest) {
            return false;
        }
        if (this.longest != other.longest) {
            return false;
        }
        return Objects.equals(this.lookupMap, other.lookupMap);
    }
}

