/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class Method
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String declaringClass;
    @Nonnull
    private final String methodName;
    public static final Method ROOT = new Method(ManagementFactory.getRuntimeMXBean().getName(), "ROOT");
    private static final Map<String, Map<String, Method>> INSTANCE_REPO = new THashMap(1024);

    public Method(StackTraceElement elem) {
        this(elem.getClassName(), elem.getMethodName());
    }

    public Method(Class<?> clasz, @Nonnull String methodName) {
        this(clasz.getName(), methodName);
    }

    public Method(@Nonnull String declaringClass, @Nonnull String methodName) {
        this.declaringClass = declaringClass;
        this.methodName = methodName;
    }

    @Nonnull
    public String getDeclaringClass() {
        return this.declaringClass;
    }

    @Nonnull
    public String getMethodName() {
        return this.methodName;
    }

    public int hashCode() {
        return 47 * this.declaringClass.hashCode() + this.methodName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        if (!this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        return this.methodName.equals(other.methodName);
    }

    public String toString() {
        return this.methodName + '@' + this.declaringClass;
    }

    public void toWriter(Writer w) throws IOException {
        w.append(this.methodName).append("@").append(this.declaringClass);
    }

    public void toHtmlWriter(Writer w) throws IOException {
        Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
        w.append(htmlEscaper.escape(this.methodName)).append(htmlEscaper.escape("@")).append(htmlEscaper.escape(this.declaringClass));
    }

    public static Method getMethod(StackTraceElement elem) {
        return Method.getMethod(elem.getClassName(), elem.getMethodName());
    }

    @SuppressFBWarnings(value={"PMB_POSSIBLE_MEMORY"})
    public static synchronized Method getMethod(String className, String methodName) {
        Method result;
        THashMap mtom = INSTANCE_REPO.get(className);
        if (mtom == null) {
            mtom = new THashMap(4);
            result = new Method(className, methodName);
            mtom.put(methodName, result);
            INSTANCE_REPO.put(className, (Map<String, Method>)mtom);
        } else {
            result = mtom.get(methodName);
            if (result == null) {
                result = new Method(className, methodName);
                mtom.put(methodName, result);
            }
        }
        return result;
    }
}

