/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.util.Objects;

public final class MutableHolder<T>
implements Comparable<MutableHolder<T>> {
    private T value;

    public MutableHolder(T value) {
        this.value = value;
    }

    public MutableHolder() {
        this.value = null;
    }

    public static <T> MutableHolder<T> of(T value) {
        return new MutableHolder<T>(value);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String toString() {
        return "MutableHolder{value=" + this.value + '}';
    }

    @Override
    public int compareTo(MutableHolder<T> o) {
        if (this.value == null) {
            if (o.value == null) {
                return 0;
            }
            return -1;
        }
        if (o.value == null) {
            return 1;
        }
        return ((Comparable)this.value).compareTo(o.value);
    }

    public int hashCode() {
        int hash = 7;
        return 79 * hash + Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableHolder other = (MutableHolder)obj;
        return Objects.equals(this.value, other.value);
    }
}

