/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Arrays;
import org.spf4j.base.Reflections;
import org.spf4j.base.SysExits;
import org.spf4j.base.Throwables;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.recyclable.impl.ArraySuppliers;
import org.spf4j.stackmonitor.FastStackCollector;

public final class Runtime {
    public static final Version JAVA_PLATFORM;
    public static final int WAIT_FOR_SHUTDOWN_MILLIS;
    public static final String TMP_FOLDER;
    public static final int PID;
    public static final String OS_NAME;
    public static final String PROCESS_NAME;
    public static final String PROCESS_ID;
    public static final int NR_PROCESSORS;
    public static final String JAVA_VERSION;
    public static final String USER_NAME;
    public static final String USER_DIR;
    public static final String USER_HOME;
    public static final String JAVA_HOME;
    private static final boolean IS_MAC_OSX;
    private static final boolean IS_WINDOWS;
    private static final SortedMap<Integer, Set<Runnable>> SHUTDOWN_HOOKS;
    private static final Path FD_FOLDER;
    public static final ThreadLocal<Long> DEADLINE;

    private Runtime() {
    }

    public static void goDownWithError(SysExits exitCode) {
        Runtime.goDownWithError(null, exitCode.exitCode());
    }

    public static void goDownWithError(@Nullable Throwable t, SysExits exitCode) {
        Runtime.goDownWithError(t, exitCode.exitCode());
    }

    @SuppressFBWarnings(value={"MDM_RUNTIME_EXIT_OR_HALT"})
    public static void goDownWithError(@Nullable Throwable t, int exitCode) {
        try {
            if (t != null) {
                Throwables.writeTo(t, System.err, Throwables.Detail.NONE);
                Throwables.writeTo(t, System.err, Throwables.Detail.STANDARD);
                Lazy.LOGGER.error("Error, going down with exit code {}", (Object)exitCode, (Object)t);
            } else {
                Lazy.LOGGER.error("Error, going down with exit code {}", (Object)exitCode);
            }
        }
        finally {
            java.lang.Runtime.getRuntime().halt(exitCode);
        }
    }

    public static boolean isMacOsx() {
        return IS_MAC_OSX;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static int getNrOpenFiles() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (Runtime.isMacOsx()) {
            if (Lsof.LSOF == null) {
                return -1;
            }
            LineCountCharHandler handler = new LineCountCharHandler();
            Runtime.run(Lsof.LSOF_CMD, handler, 60000L);
            return handler.getLineCount() - 1;
        }
        if (Files.isDirectory(FD_FOLDER, new LinkOption[0])) {
            int result = 0;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(FD_FOLDER);){
                Iterator<Path> iterator = stream.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    ++result;
                }
            }
            return result;
        }
        return -1;
    }

    @Nullable
    public static String getLsofOutput() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (Lsof.LSOF == null) {
            return null;
        }
        return Runtime.run(Lsof.LSOF_CMD, 60000L);
    }

    public static String run(String[] command, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        StringBuilderCharHandler handler = new StringBuilderCharHandler();
        int result = Runtime.run(command, handler, timeoutMillis);
        if (result != 0) {
            throw new ExecutionException("Error While Executing: " + java.util.Arrays.toString(command) + ";\n returned " + result + ";\n stdErr = " + handler.getStdErr(), null);
        }
        return handler.getStdOut();
    }

    public static int killProcess(Process proc, long terminateTimeoutMillis, long forceTerminateTimeoutMillis) throws InterruptedException {
        proc.destroy();
        if (proc.waitFor(terminateTimeoutMillis, TimeUnit.MILLISECONDS)) {
            return proc.exitValue();
        }
        proc.destroyForcibly();
        if (!proc.waitFor(forceTerminateTimeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new RuntimeException("Cannot terminate " + proc);
        }
        return proc.exitValue();
    }

    public static int run(String[] command, ProcOutputHandler handler, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        return Runtime.run(command, handler, timeoutMillis, 60000L);
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"})
    public static int run(String[] command, ProcOutputHandler handler, long timeoutMillis, long terminationTimeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
    public static void throwException(Exception ex) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof InterruptedException) {
            throw (InterruptedException)ex;
        }
        if (ex instanceof ExecutionException) {
            throw (ExecutionException)ex;
        }
        if (ex instanceof TimeoutException) {
            throw (TimeoutException)ex;
        }
        throw new ExecutionException(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueHookAtBeginning(Runnable runnable) {
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            Runtime.queueHook(Integer.MIN_VALUE, runnable);
        }
    }

    public static void queueHookAtEnd(Runnable runnable) {
        Runtime.queueHook(Integer.MAX_VALUE, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueHook(int priority, Runnable runnable) {
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            Integer pr = priority;
            HashSet<Runnable> runnables = (HashSet<Runnable>)SHUTDOWN_HOOKS.get(pr);
            if (runnables == null) {
                runnables = new HashSet<Runnable>();
                SHUTDOWN_HOOKS.put(pr, runnables);
            }
            runnables.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeQueuedShutdownHook(Runnable runnable) {
        if ("spf4j queued shutdown".equals(Thread.currentThread().getName())) {
            return false;
        }
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            for (Set<Runnable> entry : SHUTDOWN_HOOKS.values()) {
                if (!entry.remove(runnable)) continue;
                return true;
            }
        }
        return false;
    }

    public static long getDeadline() {
        return DEADLINE.get();
    }

    public static long millisToDeadline() throws TimeoutException {
        long deadline = DEADLINE.get();
        long result = deadline - System.currentTimeMillis();
        if (result < 0L) {
            throw new TimeoutException("Deadline passed " + ISODateTimeFormat.basicDateTime().print(deadline));
        }
        return result;
    }

    public static void setDeadline(long deadline) {
        DEADLINE.set(deadline);
    }

    @SuppressFBWarnings
    public static boolean gc(long timeoutMillis) {
        WeakReference<Object> ref = new WeakReference<Object>(new Object());
        long deadline = System.currentTimeMillis() + timeoutMillis;
        do {
            System.gc();
        } while (ref.get() != null && System.currentTimeMillis() < deadline);
        return ref.get() == null;
    }

    public static String jrun(Class<?> classWithMain, long timeoutMillis, String ... arguments) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return Runtime.jrun(classWithMain, classPath, timeoutMillis, arguments);
    }

    public static String jrun(Class<?> classWithMain, String classPath, long timeoutMillis, String ... arguments) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String jvmPath = JAVA_HOME + File.separatorChar + "bin" + File.separatorChar + "java";
        String[] command = Arrays.concat({jvmPath, "-cp", classPath, classWithMain.getName()}, arguments);
        return Runtime.run(command, timeoutMillis);
    }

    static {
        String osName;
        String mxBeanName;
        WAIT_FOR_SHUTDOWN_MILLIS = Integer.getInteger("spf4j.waitForShutdownMillis", 30000);
        TMP_FOLDER = System.getProperty("java.io.tmpdir");
        JAVA_VERSION = System.getProperty("java.version");
        USER_NAME = System.getProperty("user.name");
        USER_DIR = System.getProperty("user.dir");
        USER_HOME = System.getProperty("user.home");
        JAVA_HOME = System.getProperty("java.home");
        SHUTDOWN_HOOKS = new TreeMap<Integer, Set<Runnable>>();
        java.lang.Runtime runtime = java.lang.Runtime.getRuntime();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        int availableProcessors = runtime.availableProcessors();
        if (availableProcessors <= 0) {
            System.err.println("Invalid number of processors " + availableProcessors + " defaulting to 1");
            NR_PROCESSORS = 1;
        } else {
            NR_PROCESSORS = availableProcessors;
        }
        PROCESS_NAME = mxBeanName = runtimeMxBean.getName();
        PROCESS_ID = mxBeanName + ':' + Long.toHexString(System.currentTimeMillis());
        int atIdx = mxBeanName.indexOf(64);
        PID = atIdx < 0 ? -1 : Integer.parseInt(mxBeanName.substring(0, atIdx));
        OS_NAME = osName = System.getProperty("os.name");
        IS_MAC_OSX = "Mac OS X".equals(osName);
        IS_WINDOWS = osName.startsWith("Windows");
        runtime.addShutdownHook(new Thread((Runnable)new AbstractRunnable(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void doRun() throws Exception {
                void var8_25;
                TreeMap hooks;
                Exception rex = null;
                SortedMap sortedMap = SHUTDOWN_HOOKS;
                synchronized (sortedMap) {
                    hooks = new TreeMap(SHUTDOWN_HOOKS);
                    for (Map.Entry entry : hooks.entrySet()) {
                        entry.setValue(new HashSet((Collection)entry.getValue()));
                    }
                }
                for (Map.Entry entry : hooks.entrySet()) {
                    Set set = (Set)entry.getValue();
                    if (set.size() <= 1) {
                        for (Runnable runnable : set) {
                            try {
                                runnable.run();
                            }
                            catch (RuntimeException runtimeException) {
                                if (rex == null) {
                                    rex = runtimeException;
                                    continue;
                                }
                                rex.addSuppressed(runtimeException);
                            }
                        }
                        continue;
                    }
                    if ((Integer)entry.getKey() >= Integer.MAX_VALUE) {
                        Thread[] threads = new Thread[set.size()];
                        int i = 0;
                        for (Runnable runnable : set) {
                            Thread thread = new Thread(runnable);
                            thread.start();
                            threads[i++] = thread;
                        }
                        long l = System.currentTimeMillis() + (long)WAIT_FOR_SHUTDOWN_MILLIS;
                        for (Thread thread : threads) {
                            try {
                                thread.join(l - System.currentTimeMillis());
                            }
                            catch (InterruptedException ex) {
                                if (rex == null) {
                                    rex = ex;
                                    continue;
                                }
                                rex.addSuppressed(ex);
                            }
                        }
                        continue;
                    }
                    ArrayList futures = new ArrayList(set.size());
                    for (Runnable runnable : set) {
                        futures.add(DefaultExecutor.INSTANCE.submit(runnable));
                    }
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (InterruptedException | RuntimeException | ExecutionException ex) {
                            if (rex == null) {
                                rex = ex;
                                continue;
                            }
                            rex.addSuppressed(ex);
                        }
                    }
                }
                Thread[] threads = FastStackCollector.getThreads();
                Thread thread = Thread.currentThread();
                boolean bl = true;
                Thread[] threadArray = threads;
                int n = threadArray.length;
                boolean bl2 = false;
                while (var8_25 < n) {
                    Object thread2 = threadArray[var8_25];
                    if (((Thread)thread2).isAlive() && !((Thread)thread2).isDaemon() && !thread2.equals(thread) && !((Thread)thread2).getName().contains("DestroyJavaVM")) {
                        boolean bl3;
                        if (bl3) {
                            System.err.println("Non daemon threads still running:");
                            bl3 = false;
                        }
                        System.err.println("Non daemon thread " + thread2 + ", stackTrace = " + java.util.Arrays.toString(((Thread)thread2).getStackTrace()));
                    }
                    ++var8_25;
                }
                if (rex != null) {
                    throw rex;
                }
            }
        }, "spf4j queued shutdown"));
        JAVA_PLATFORM = Version.fromSpecVersion(JAVA_VERSION);
        Registry.export(Jmx.class);
        FD_FOLDER = Paths.get("/proc/" + PID + "/fd", new String[0]);
        try (PrintStream stream = new PrintStream((OutputStream)new ByteArrayBuilder(), false, "UTF-8");){
            Throwables.writeTo((Throwable)new RuntimeException("priming"), stream, Throwables.Detail.NONE);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        DEADLINE = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return Long.MAX_VALUE;
            }
        };
    }

    private static class StdOutHandlerRunnable
    extends AbstractRunnable {
        private final ProcOutputHandler handler;
        private final InputStream is;

        StdOutHandlerRunnable(ProcOutputHandler handler, InputStream is) {
            this.handler = handler;
            this.is = is;
        }

        @Override
        public void doRun() throws Exception {
            byte[] buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(8192);
            try {
                int cos;
                while ((cos = this.is.read(buffer)) >= 0) {
                    this.handler.handleStdOut(buffer, cos);
                }
            }
            finally {
                ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
                this.handler.stdOutDone();
            }
        }
    }

    private static class StdErrHandlerRunnable
    extends AbstractRunnable {
        private final ProcOutputHandler handler;
        private final InputStream is;

        StdErrHandlerRunnable(ProcOutputHandler handler, InputStream is) {
            this.handler = handler;
            this.is = is;
        }

        @Override
        public void doRun() throws Exception {
            byte[] buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(8192);
            try {
                int eos;
                while ((eos = this.is.read(buffer)) >= 0) {
                    this.handler.handleStdErr(buffer, eos);
                }
            }
            finally {
                ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
                this.handler.stdErrDone();
            }
        }
    }

    public static final class Jmx {
        @JmxExport
        public static Reflections.PackageInfo getPackageInfo(@JmxExport(value="className") String className) {
            return Reflections.getPackageInfo(className);
        }
    }

    public static final class StringBuilderCharHandler
    implements ProcOutputHandler {
        private final Charset charset;
        private final ByteArrayBuilder stdout = new ByteArrayBuilder(128, ArraySuppliers.Bytes.JAVA_NEW);
        private final ByteArrayBuilder stderr = new ByteArrayBuilder(0, ArraySuppliers.Bytes.JAVA_NEW);

        public StringBuilderCharHandler(Charset charset) {
            this.charset = charset;
        }

        public StringBuilderCharHandler() {
            this(Charset.defaultCharset());
        }

        @Override
        public void handleStdOut(byte[] buffer, int length) {
            this.stdout.write(buffer, 0, length);
        }

        public String toString() {
            return "OUT: " + new String(this.stdout.getBuffer(), 0, this.stdout.size(), this.charset) + "\nERR: " + new String(this.stderr.getBuffer(), 0, this.stderr.size(), this.charset);
        }

        public String getStdOut() {
            return new String(this.stdout.getBuffer(), 0, this.stdout.size(), this.charset);
        }

        public String getStdErr() {
            return new String(this.stderr.getBuffer(), 0, this.stderr.size(), this.charset);
        }

        @Override
        public void handleStdErr(byte[] buffer, int length) {
            this.stderr.write(buffer, 0, length);
        }

        @Override
        public void stdOutDone() {
        }

        @Override
        public void stdErrDone() {
        }
    }

    public static final class LineCountCharHandler
    implements ProcOutputHandler {
        private int lineCount = 0;

        @Override
        public void handleStdOut(byte[] buffer, int length) {
            for (int i = 0; i < length; ++i) {
                byte c = buffer[i];
                if (c != 10) continue;
                ++this.lineCount;
            }
        }

        public int getLineCount() {
            return this.lineCount;
        }

        @Override
        public void handleStdErr(byte[] buffer, int length) {
            this.handleStdOut(buffer, length);
        }

        @Override
        public void stdOutDone() {
        }

        @Override
        public void stdErrDone() {
        }
    }

    public static interface ProcOutputHandler {
        public void handleStdOut(byte[] var1, int var2);

        public void stdOutDone();

        public void handleStdErr(byte[] var1, int var2);

        public void stdErrDone();
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static final class Ulimit {
        private static final File BASH;
        private static final File SH;
        private static final File ULIMIT;
        private static final String[] ULIMIT_CMD;
        public static final int MAX_NR_OPENFILES;

        public static int runUlimit(String ... options) {
            int mfiles;
            if (ULIMIT_CMD == null) {
                throw new RuntimeException("Ulimit not available on " + OS_NAME);
            }
            try {
                String result = Runtime.run(Arrays.concat(ULIMIT_CMD, options), 10000L);
                mfiles = result.contains("unlimited") ? Integer.MAX_VALUE : Integer.parseInt(result.trim());
            }
            catch (IOException | InterruptedException | ExecutionException | TimeoutException ex) {
                Lazy.LOGGER.error("Error while running ulimit, assuming no limit", (Throwable)ex);
                mfiles = Integer.MAX_VALUE;
            }
            return mfiles;
        }

        static {
            int mfiles;
            BASH = new File("/bin/bash");
            SH = new File("/bin/sh");
            ULIMIT = new File("/usr/bin/ulimit");
            ULIMIT_CMD = ULIMIT.exists() && ULIMIT.canExecute() ? new String[]{ULIMIT.getPath()} : (BASH.exists() && BASH.canExecute() ? new String[]{BASH.getPath(), "-c", "ulimit"} : (SH.exists() && SH.canExecute() ? new String[]{SH.getPath(), "-c", "ulimit"} : null));
            if (ULIMIT_CMD == null) {
                Lazy.LOGGER.warn("No ulimit available on {}, assuming no limit for nr open files", (Object)OS_NAME);
                mfiles = Integer.MAX_VALUE;
            } else {
                mfiles = Ulimit.runUlimit("-Sn");
            }
            MAX_NR_OPENFILES = mfiles;
        }
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static final class Lsof {
        public static final File LSOF;
        public static final String[] LSOF_CMD;

        static {
            String[] stringArray;
            File lsofFile = new File("/usr/sbin/lsof");
            if (!(lsofFile.exists() && lsofFile.canExecute() || (lsofFile = new File("/usr/bin/lsof")).exists() && lsofFile.canExecute() || (lsofFile = new File("/usr/local/bin/lsof")).exists() && lsofFile.canExecute())) {
                lsofFile = null;
            }
            if ((LSOF = lsofFile) == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[3];
                stringArray2[0] = LSOF.getAbsolutePath();
                stringArray2[1] = "-p";
                stringArray = stringArray2;
                stringArray2[2] = Integer.toString(PID);
            }
            LSOF_CMD = stringArray;
        }
    }

    private static class Lazy {
        private static final Logger LOGGER = LoggerFactory.getLogger(Lazy.class);

        private Lazy() {
        }
    }

    public static enum Version {
        V1_0,
        V1_1,
        V1_2,
        V1_3,
        V1_4,
        V1_5,
        V1_6,
        V1_7,
        V1_8,
        V1_9_PLUSZ;


        public static Version fromSpecVersion(String specVersion) {
            return Version.values()[Integer.parseInt(specVersion.split("\\.")[1])];
        }
    }
}

