/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spf4j.base.Comparables;

public final class Version
implements Comparable<Version> {
    private final Comparable[] components;
    private final String image;

    public Version(String version) {
        this.image = version;
        ArrayList comps = new ArrayList(4);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < version.length(); ++i) {
            char prev;
            char c = version.charAt(i);
            int length = sb.length();
            if (c == '.') {
                Version.addPart(sb, comps);
                sb.setLength(0);
                continue;
            }
            if (Character.isDigit(c)) {
                if (length > 0 && !Character.isDigit(prev = sb.charAt(length - 1))) {
                    comps.add((Comparable<?>)((Object)sb.toString()));
                    sb.setLength(0);
                }
                sb.append(c);
                continue;
            }
            if (length > 0 && Character.isDigit(prev = sb.charAt(length - 1))) {
                comps.add(Integer.valueOf(sb.toString()));
                sb.setLength(0);
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            Version.addPart(sb, comps);
        }
        this.components = comps.toArray(new Comparable[comps.size()]);
    }

    private static void addPart(StringBuilder sb, List<Comparable<?>> comps) {
        String strPart = sb.toString();
        Integer nr = Ints.tryParse((String)strPart);
        if (nr == null) {
            comps.add((Comparable<?>)((Object)strPart));
        } else {
            comps.add(nr);
        }
    }

    @Override
    public int compareTo(Version o) {
        return Comparables.compareArrays((Comparable[])this.components, (Comparable[])o.components);
    }

    public int hashCode() {
        return this.image.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public String getImage() {
        return this.image;
    }

    public Comparable[] getComponents() {
        return (Comparable[])this.components.clone();
    }

    public String toString() {
        return "Version{components=" + Arrays.toString(this.components) + '}';
    }
}

