/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillClose;
import org.spf4j.base.Runtime;

public final class FileBasedLock
implements Lock,
Closeable {
    private static final Map<String, Lock> JVM_LOCKS = new HashMap<String, Lock>();
    private final RandomAccessFile file;
    private final Lock jvmLock;
    private FileLock fileLock;
    private volatile Thread owner;
    private int reentranceCount = 0;

    private static int next(int maxVal) {
        return Math.abs(Math.abs(ThreadLocalRandom.current().nextInt()) % maxVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedLock(File lockFile) throws IOException {
        this.file = new RandomAccessFile(lockFile, "rws");
        String filePath = lockFile.getPath();
        Map<String, Lock> map = JVM_LOCKS;
        synchronized (map) {
            Lock lock = JVM_LOCKS.get(filePath);
            if (lock == null) {
                lock = new ReentrantLock();
                JVM_LOCKS.put(filePath, lock);
            }
            this.jvmLock = lock;
        }
        this.fileLock = null;
    }

    @Override
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT"})
    public void lock() {
        this.jvmLock.lock();
        Thread currentThread = Thread.currentThread();
        if (currentThread.equals(this.owner)) {
            ++this.reentranceCount;
            return;
        }
        try {
            this.fileLock = this.file.getChannel().lock();
            this.owner = currentThread;
            ++this.reentranceCount;
            this.writeHolderInfo();
        }
        catch (IOException ex) {
            this.unlockInternal();
            throw new RuntimeException(ex);
        }
        catch (RuntimeException ex) {
            this.unlockInternal();
            throw ex;
        }
    }

    private void unlockInternal() {
        this.jvmLock.unlock();
        --this.reentranceCount;
        if (this.reentranceCount == 0) {
            this.owner = null;
        } else if (this.reentranceCount < 0) {
            throw new RuntimeException("Not owner of this lock " + this);
        }
    }

    @Override
    @SuppressFBWarnings(value={"MDM_WAIT_WITHOUT_TIMEOUT", "EXS_EXCEPTION_SOFTENING_HAS_CHECKED", "MDM_THREAD_YIELD"})
    public void lockInterruptibly() throws InterruptedException {
        this.jvmLock.lockInterruptibly();
        Thread currentThread = Thread.currentThread();
        if (currentThread.equals(this.owner)) {
            ++this.reentranceCount;
            return;
        }
        try {
            FileChannel channel = this.file.getChannel();
            while ((this.fileLock = channel.tryLock()) == null && !Thread.interrupted()) {
                Thread.sleep(FileBasedLock.next(1000));
            }
            this.owner = currentThread;
            ++this.reentranceCount;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.writeHolderInfo();
        }
        catch (InterruptedException | RuntimeException ex) {
            this.unlockInternal();
            throw ex;
        }
        catch (IOException ex) {
            this.unlockInternal();
            throw new RuntimeException(ex);
        }
    }

    @Override
    @SuppressFBWarnings(value={"MDM_THREAD_FAIRNESS"})
    public boolean tryLock() {
        if (this.jvmLock.tryLock()) {
            Thread currentThread = Thread.currentThread();
            if (currentThread.equals(this.owner)) {
                ++this.reentranceCount;
                return true;
            }
            try {
                this.fileLock = this.file.getChannel().tryLock();
                if (this.fileLock != null) {
                    this.owner = currentThread;
                    ++this.reentranceCount;
                    this.writeHolderInfo();
                    return true;
                }
                return false;
            }
            catch (IOException ex) {
                this.unlockInternal();
                throw new RuntimeException(ex);
            }
            catch (RuntimeException ex) {
                this.unlockInternal();
                throw ex;
            }
        }
        return false;
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_HAS_CHECKED", "MDM_THREAD_YIELD"})
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (this.jvmLock.tryLock(time, unit)) {
            Thread currentThread = Thread.currentThread();
            if (currentThread.equals(this.owner)) {
                ++this.reentranceCount;
                return true;
            }
            try {
                long maxWaitTime = unit.toMillis(time);
                for (long waitTime = 0L; waitTime < maxWaitTime && (this.fileLock = this.file.getChannel().tryLock()) == null && !Thread.interrupted(); ++waitTime) {
                    Thread.sleep(FileBasedLock.next(1000));
                }
                this.owner = currentThread;
                ++this.reentranceCount;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (this.fileLock != null) {
                    this.writeHolderInfo();
                    return true;
                }
                return false;
            }
            catch (InterruptedException | RuntimeException ex) {
                this.unlockInternal();
                throw ex;
            }
            catch (IOException ex) {
                this.unlockInternal();
                throw new RuntimeException(ex);
            }
        }
        return false;
    }

    @Override
    public void unlock() {
        if (!Thread.currentThread().equals(this.owner)) {
            throw new IllegalStateException("Lock " + this + " not owned by current thread " + Thread.currentThread());
        }
        try {
            this.fileLock.release();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.unlockInternal();
        }
    }

    @Override
    public Condition newCondition() {
        return this.jvmLock.newCondition();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.forceClose();
        }
    }

    @Override
    @WillClose
    public void close() throws IOException {
        Thread o = this.owner;
        if (o == null) {
            this.file.close();
        } else if (Thread.currentThread().equals(o)) {
            try {
                this.file.close();
            }
            finally {
                this.unlockInternal();
            }
        } else {
            throw new IllegalStateException("Lock " + this + " not owned by current thread " + Thread.currentThread());
        }
    }

    @WillClose
    public void forceClose() throws IOException {
        this.file.close();
    }

    private void writeHolderInfo() throws IOException {
        this.file.seek(0L);
        byte[] data = FileBasedLock.getContextInfo().getBytes(Charsets.UTF_8);
        this.file.write(data);
        this.file.setLength(data.length);
        this.file.getChannel().force(true);
    }

    public static String getContextInfo() {
        return Runtime.PROCESS_ID + ':' + Thread.currentThread().getName();
    }

    public String toString() {
        return "FileBasedLock{file=" + this.file + ", owner=" + this.owner + ", reentranceCount=" + this.reentranceCount + '}';
    }
}

