/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.Either;

@ThreadSafe
@SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
public class FutureBean<T>
implements Future<T> {
    private volatile Either<T, ? extends ExecutionException> resultStore;

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final boolean isCancelled() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public final boolean isDone() {
        return this.resultStore != null;
    }

    public final Either<T, ? extends ExecutionException> getResultStore() {
        return this.resultStore;
    }

    @Override
    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION", "MDM_WAIT_WITHOUT_TIMEOUT"})
    public final synchronized T get() throws InterruptedException, ExecutionException {
        while (this.resultStore == null) {
            this.wait();
        }
        return FutureBean.processResult(this.resultStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis;
        long toWait = timeoutMillis = unit.toMillis(timeout);
        long startTime = System.currentTimeMillis();
        FutureBean futureBean = this;
        synchronized (futureBean) {
            while (toWait > 0L && this.resultStore == null) {
                this.wait(toWait);
                toWait = timeoutMillis - (System.currentTimeMillis() - startTime);
            }
            if (this.resultStore == null) {
                throw new TimeoutException();
            }
            return FutureBean.processResult(this.resultStore);
        }
    }

    public static <T> T processResult(Either<T, ? extends ExecutionException> result) throws ExecutionException {
        if (result.isLeft()) {
            return result.getLeft();
        }
        throw result.getRight();
    }

    public final synchronized void setResult(T result) {
        if (this.resultStore != null) {
            throw new IllegalStateException("cannot set result multiple times " + result);
        }
        this.resultStore = Either.left(result);
        this.done();
        this.notifyAll();
    }

    public final synchronized void setExceptionResult(ExecutionException result) {
        if (this.resultStore != null) {
            throw new IllegalStateException("cannot set result multiple times " + result);
        }
        this.resultStore = Either.right(result);
        this.done();
        this.notifyAll();
    }

    public void done() {
    }

    public final String toString() {
        return "FutureBean{resultStore=" + this.resultStore + '}';
    }
}

