/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Callables;
import org.spf4j.base.ParameterizedSupplier;
import org.spf4j.base.Throwables;
import org.spf4j.base.TimeoutRunnable;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.FutureBean;

public class RetryExecutor {
    private final ExecutorService executionService;
    private final DelayQueue<FailedExecutionResult> executionEvents = new DelayQueue();
    private final ParameterizedSupplier<Callables.DelayPredicate<Object>, Callable<?>> resultRetryPredicateSupplier;
    private final ParameterizedSupplier<Callables.DelayPredicate<Exception>, Callable<?>> exceptionRetryPredicateSupplier;
    private volatile RetryManager retryManager;
    private Future<?> retryManagerFuture;
    private final BlockingQueue<Future<?>> completionQueue;
    private final Object sync = new Object();
    public static final ParameterizedSupplier<Callables.DelayPredicate<Object>, Callable<Object>> NO_RETRY_SUPPLIER = new ParameterizedSupplier<Callables.DelayPredicate<Object>, Callable<Object>>(){

        @Override
        public Callables.DelayPredicate<Object> get(Callable<Object> parameter) {
            return Callables.DelayPredicate.NORETRY_DELAY_PREDICATE;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRetryManager() {
        if (this.retryManager == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.retryManager == null) {
                    this.retryManager = new RetryManager();
                    this.retryManagerFuture = DefaultExecutor.INSTANCE.submit(this.retryManager);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownRetryManager() {
        Object object = this.sync;
        synchronized (object) {
            if (this.retryManager != null) {
                this.retryManager.shutdown();
                this.retryManager = null;
            }
        }
    }

    public RetryExecutor(ExecutorService exec, ParameterizedSupplier<Callables.DelayPredicate<Exception>, Callable<Object>> exceptionRetryPredicateSupplier, @Nullable BlockingQueue<Future<?>> completionQueue) {
        this(exec, NO_RETRY_SUPPLIER, exceptionRetryPredicateSupplier, completionQueue);
    }

    public RetryExecutor(ExecutorService exec, ParameterizedSupplier<Callables.DelayPredicate<Object>, Callable<?>> resultRetryPredicateSupplier, ParameterizedSupplier<Callables.DelayPredicate<Exception>, Callable<?>> exceptionRetryPredicateSupplier, @Nullable BlockingQueue<Future<?>> completionQueue) {
        this.executionService = exec;
        this.resultRetryPredicateSupplier = resultRetryPredicateSupplier;
        this.exceptionRetryPredicateSupplier = exceptionRetryPredicateSupplier;
        this.completionQueue = completionQueue;
    }

    public final void shutdown() {
        this.shutdownRetryManager();
        this.executionService.shutdown();
    }

    public final List<Runnable> shutdownNow() {
        this.shutdownRetryManager();
        return this.executionService.shutdownNow();
    }

    public final boolean isShutdown() {
        return this.executionService.isShutdown();
    }

    public final boolean isTerminated() {
        return this.executionService.isTerminated();
    }

    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.retryManagerFuture.get();
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        return this.executionService.awaitTermination(timeout, unit);
    }

    private FutureBean<?> createFutureBean() {
        if (this.completionQueue == null) {
            return new FutureBean();
        }
        return new FutureBean<Object>(){

            @Override
            public void done() {
                RetryExecutor.this.completionQueue.add(this);
            }
        };
    }

    public final <A, E extends Exception> Future<A> submit(Callables.TimeoutCallable<A, E> task) {
        FutureBean<?> result = this.createFutureBean();
        this.executionService.execute(new RetryableCallable(task, result, null, this.resultRetryPredicateSupplier.get(task), this.exceptionRetryPredicateSupplier.get(task)));
        return result;
    }

    public final <A> Future<A> submit(Callable<A> task) {
        FutureBean<?> result = this.createFutureBean();
        this.executionService.execute(new RetryableCallable<A>(task, result, null, this.resultRetryPredicateSupplier.get(task), this.exceptionRetryPredicateSupplier.get(task)));
        return result;
    }

    public final <A, E extends Exception> Future<A> submit(TimeoutRunnable<E> task, A result) {
        FutureBean<?> resultFuture = this.createFutureBean();
        this.executionService.execute(new RetryableCallable(task, result, resultFuture, null, this.resultRetryPredicateSupplier.get(task), this.exceptionRetryPredicateSupplier.get(task)));
        return resultFuture;
    }

    public final <E extends Exception> Future<?> submit(TimeoutRunnable<E> task) {
        FutureBean<?> resultFuture = this.createFutureBean();
        this.executionService.execute(new RetryableCallable(task, null, resultFuture, null, this.resultRetryPredicateSupplier.get(task), this.exceptionRetryPredicateSupplier.get(task)));
        return resultFuture;
    }

    public final <E extends Exception> void execute(TimeoutRunnable<E> command) {
        this.executionService.execute(new RetryableCallable(command, null, null, null, this.resultRetryPredicateSupplier.get(command), this.exceptionRetryPredicateSupplier.get(command)));
    }

    public final String toString() {
        return "RetryExecutor{executionService=" + this.executionService + ", executionEvents=" + this.executionEvents + ", resultRetryPredicateSupplier=" + this.resultRetryPredicateSupplier + ", exceptionRetryPredicateSupplier=" + this.exceptionRetryPredicateSupplier + ", retryManager=" + this.retryManager + ", retryManagerFuture=" + this.retryManagerFuture + ", completionQueue=" + this.completionQueue + ", sync=" + this.sync + '}';
    }

    private class RetryManager
    extends AbstractRunnable {
        private volatile boolean isRunning;

        RetryManager() {
            super("RetryManager");
            this.isRunning = true;
        }

        public void shutdown() {
            this.isRunning = false;
        }

        @Override
        public void doRun() {
            while (this.isRunning) {
                try {
                    FailedExecutionResult event = (FailedExecutionResult)RetryExecutor.this.executionEvents.poll(1000L, TimeUnit.SECONDS);
                    if (event == null) continue;
                    RetryableCallable<Object> callable = event.getCallable();
                    callable.setPreviousResult(event);
                    RetryExecutor.this.executionService.execute(callable);
                }
                catch (InterruptedException ex) {
                    this.isRunning = false;
                    break;
                }
            }
        }
    }

    private class RetryableCallable<T>
    implements Callable<T>,
    Runnable {
        private final Callable<T> callable;
        private final FutureBean<T> future;
        private volatile FailedExecutionResult previousResult;
        private final Callables.DelayPredicate<Object> resultRetryPredicate;
        private final Callables.DelayPredicate<Exception> exceptionRetryPredicate;

        RetryableCallable(Callable<T> callable, FutureBean<T> future, FailedExecutionResult previousResult, Callables.DelayPredicate<?> resultRetryPredicate, Callables.DelayPredicate<Exception> exceptionRetryPredicate) {
            this.callable = callable;
            this.future = future;
            this.previousResult = previousResult;
            this.resultRetryPredicate = resultRetryPredicate;
            this.exceptionRetryPredicate = exceptionRetryPredicate;
        }

        RetryableCallable(final Runnable task, final Object result, @Nullable FutureBean<T> future, FailedExecutionResult previousResult, Callables.DelayPredicate<?> resultRetryPredicate, Callables.DelayPredicate<Exception> exceptionRetryPredicate) {
            this(new Callable(){

                public Object call() {
                    task.run();
                    return result;
                }
            }, future, previousResult, resultRetryPredicate, exceptionRetryPredicate);
        }

        @Override
        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
        public T call() {
            try {
                T result = this.callable.call();
                int delay = this.resultRetryPredicate.apply(result);
                if (delay >= 0) {
                    RetryExecutor.this.startRetryManager();
                    RetryExecutor.this.executionEvents.add(new FailedExecutionResult(null, this, delay));
                } else if (this.future != null) {
                    this.future.setResult(result);
                }
                return null;
            }
            catch (Exception e) {
                int delay = this.exceptionRetryPredicate.apply(e);
                if (delay >= 0) {
                    ExecutionException exception;
                    RetryExecutor.this.startRetryManager();
                    if (this.previousResult != null && (exception = this.previousResult.getException()) != null) {
                        e = Throwables.suppress(e, exception);
                    }
                    RetryExecutor.this.executionEvents.add(new FailedExecutionResult(new ExecutionException(e), this, delay));
                } else {
                    this.future.setExceptionResult(new ExecutionException(e));
                }
                return null;
            }
        }

        @Override
        public void run() {
            this.call();
        }

        public FailedExecutionResult getPreviousResult() {
            return this.previousResult;
        }

        public void setPreviousResult(FailedExecutionResult previousResult) {
            this.previousResult = previousResult;
        }
    }

    private static class FailedExecutionResult
    implements Delayed {
        private final ExecutionException exception;
        private final RetryableCallable<Object> callable;
        private final long deadline;

        FailedExecutionResult(@Nullable ExecutionException exception, RetryableCallable callable, long delay) {
            this.exception = exception;
            this.callable = callable;
            this.deadline = delay + System.currentTimeMillis();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long oDelay;
            long tDelay = this.getDelay(TimeUnit.MILLISECONDS);
            if (tDelay > (oDelay = o.getDelay(TimeUnit.MILLISECONDS))) {
                return 1;
            }
            if (tDelay < oDelay) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof FailedExecutionResult) {
                return this.compareTo((FailedExecutionResult)obj) == 0;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            return 53 * hash + (this.callable != null ? this.callable.hashCode() : 0);
        }

        @Nullable
        public ExecutionException getException() {
            return this.exception;
        }

        public RetryableCallable<Object> getCallable() {
            return this.callable;
        }
    }
}

