/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.io.BaseEncoding;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Runtime;
import org.spf4j.base.Strings;
import org.spf4j.concurrent.Sequence;

@ParametersAreNonnullByDefault
public final class UIDGenerator
implements Supplier<CharSequence> {
    private final Sequence sequence;
    private final StringBuilder base;
    private final int maxSize;

    public UIDGenerator(Sequence sequence) {
        this(sequence, 0L);
    }

    public UIDGenerator(Sequence sequence, String prefix) {
        this(sequence, BaseEncoding.base64Url(), 0L, '.', prefix);
    }

    public UIDGenerator(Sequence sequence, long customEpoch) {
        this(sequence, BaseEncoding.base64Url(), customEpoch, '.', "");
    }

    public UIDGenerator(Sequence sequence, String prefix, long customEpoch) {
        this(sequence, BaseEncoding.base64Url(), customEpoch, '.', prefix);
    }

    @SuppressFBWarnings(value={"STT_TOSTRING_STORED_IN_FIELD"})
    public UIDGenerator(Sequence sequence, @Nullable BaseEncoding baseEncoding, long customEpoch, char separator, String prefix) {
        this.sequence = sequence;
        StringBuilder sb = new StringBuilder(16 + prefix.length());
        sb.append(prefix);
        if (baseEncoding != null) {
            byte[] intfMac;
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                if (networkInterfaces != null && networkInterfaces.hasMoreElements()) {
                    while (((intfMac = networkInterfaces.nextElement().getHardwareAddress()) == null || intfMac.length == 0) && networkInterfaces.hasMoreElements()) {
                    }
                    if (intfMac == null) {
                        intfMac = new byte[]{0};
                    }
                } else {
                    intfMac = new byte[]{0};
                }
            }
            catch (SocketException ex) {
                throw new RuntimeException(ex);
            }
            sb.append(baseEncoding.encode(intfMac)).append(separator);
        }
        Strings.appendUnsignedString(sb, Runtime.PID, 5);
        sb.append(separator);
        Strings.appendUnsignedString(sb, (System.currentTimeMillis() - customEpoch) / 1000L, 5);
        sb.append(separator);
        this.base = sb;
        this.maxSize = this.base.length() + 16;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public CharSequence next() {
        StringBuilder result = new StringBuilder(this.maxSize);
        result.append((CharSequence)this.base);
        Strings.appendUnsignedString(result, this.sequence.next(), 5);
        return result;
    }

    public String toString() {
        return "UIDGenerator{sequence=" + this.sequence + ", base=" + this.base + ", maxSize=" + this.maxSize + '}';
    }

    @Override
    public CharSequence get() {
        return this.next();
    }
}

