/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.ParametersAreNonnullByDefault;

@Deprecated
@ParametersAreNonnullByDefault
public final class UnboundedRacyLoadingCache<K, V>
implements LoadingCache<K, V> {
    private final ConcurrentMap<K, V> map;
    private final CacheLoader<K, V> loader;

    public UnboundedRacyLoadingCache(int initialSize, CacheLoader<K, V> loader) {
        this(initialSize, 8, loader);
    }

    public UnboundedRacyLoadingCache(int initialSize, int concurrency, CacheLoader<K, V> loader) {
        this.map = new ConcurrentHashMap(initialSize, 0.75f, concurrency);
        this.loader = loader;
    }

    public V get(K key) throws ExecutionException {
        Object val = this.map.get(key);
        if (val == null) {
            try {
                val = this.loader.load(key);
            }
            catch (Exception ex) {
                throw new ExecutionException(ex);
            }
            this.map.put(key, val);
        }
        return val;
    }

    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (K key : keys) {
            builder.put(key, this.get(key));
        }
        return builder.build();
    }

    public V apply(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null for " + this);
        }
        return this.getUnchecked(key);
    }

    public void refresh(K key) {
        this.getUnchecked(key);
    }

    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    public V getIfPresent(Object key) {
        return this.map.get(key);
    }

    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        Object val = this.map.get(key);
        if (val == null) {
            try {
                val = valueLoader.call();
            }
            catch (Exception ex) {
                throw new ExecutionException(ex);
            }
            this.map.put(key, val);
        }
        return val;
    }

    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object key : keys) {
            V val = this.getIfPresent(key);
            if (val == null) continue;
            builder.put(key, val);
        }
        return builder.build();
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void invalidate(Object key) {
        this.map.remove(key);
    }

    public void invalidateAll(Iterable<?> keys) {
        for (Object key : keys) {
            this.invalidate(key);
        }
    }

    public void invalidateAll() {
        this.map.clear();
    }

    public long size() {
        return this.map.size();
    }

    public CacheStats stats() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void cleanUp() {
        this.map.clear();
    }

    public String toString() {
        return "UnboundedRacyLoadingCache{map=" + this.map + ", loader=" + this.loader + '}';
    }
}

