/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.spf4j.io.PathsIOException;

public final class DeletingVisitor
implements FileVisitor<Path> {
    private Path rootFolder = null;
    private PathsIOException exception = null;

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        try {
            Files.delete(file);
        }
        catch (IOException ex) {
            if (this.rootFolder == null) {
                throw new PathsIOException(file, ex);
            }
            this.suppress(ex, file);
        }
        return FileVisitResult.CONTINUE;
    }

    private void suppress(IOException ex, Path path) {
        if (this.exception == null) {
            this.exception = new PathsIOException(path, ex);
        } else {
            this.exception.add(path, ex);
        }
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        try {
            Files.delete(dir);
        }
        catch (IOException ex) {
            this.suppress(ex, dir);
        }
        if (this.exception != null && dir.equals(this.rootFolder)) {
            throw this.exception;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        if (this.rootFolder == null) {
            this.rootFolder = dir;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (this.rootFolder == null) {
            throw new PathsIOException(file, exc);
        }
        this.suppress(exc, file);
        return FileVisitResult.CONTINUE;
    }

    public String toString() {
        return "DeletingVisitor{rootFolder=" + this.rootFolder + ", exception=" + this.exception + '}';
    }
}

