/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.spf4j.io.csv.CsvReader;

public final class CsvReader2Iterator
implements Iterator<List<String>> {
    private final CsvReader reader;
    private final List<String> row = new ArrayList<String>();
    private boolean haveParsedRow = false;

    public CsvReader2Iterator(CsvReader preader) {
        this.reader = preader;
    }

    private CsvReader.TokenType readRow() throws IOException {
        CsvReader.TokenType token;
        this.row.clear();
        boolean loop = true;
        do {
            token = this.reader.next();
            switch (token) {
                case ELEMENT: {
                    this.row.add(this.reader.getElement().toString());
                    break;
                }
                case END_DOCUMENT: 
                case END_ROW: {
                    loop = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal token " + (Object)((Object)token));
                }
            }
        } while (loop);
        this.haveParsedRow = !this.row.isEmpty();
        return token;
    }

    @Override
    public boolean hasNext() {
        if (!this.haveParsedRow) {
            try {
                CsvReader.TokenType token = this.readRow();
                if (this.haveParsedRow) {
                    return true;
                }
                return token != CsvReader.TokenType.END_DOCUMENT;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return true;
    }

    @Override
    public List<String> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.haveParsedRow = false;
        return this.row;
    }

    public String toString() {
        return "CsvReader2Iterator{reader=" + this.reader + ", row=" + this.row + ", haveParsedRow=" + this.haveParsedRow + '}';
    }
}

