/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import com.google.common.base.Throwables;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.OpenType;
import org.spf4j.base.Reflections;
import org.spf4j.jmx.ExportedOperation;
import org.spf4j.jmx.ExportedValue;
import org.spf4j.jmx.OpenTypeConverter;

public final class ExportedValuesMBean
implements DynamicMBean {
    private static final Pattern INVALID_CHARS = Pattern.compile("[^a-zA-Z0-9_\\-\\.]");
    private final Map<String, ExportedValue<?>> exportedValues;
    private final Map<String, ExportedOperation> exportedOperations;
    private final ObjectName objectName;
    private final MBeanInfo beanInfo;

    ExportedValuesMBean(ObjectName objectName, ExportedValue<?>[] exported, ExportedOperation[] operations) {
        this.exportedValues = new HashMap(exported.length);
        for (ExportedValue<?> val : exported) {
            this.exportedValues.put(val.getName(), val);
        }
        this.exportedOperations = new HashMap<String, ExportedOperation>(operations.length);
        for (ExportedOperation op : operations) {
            this.exportedOperations.put(op.getName(), op);
        }
        this.objectName = objectName;
        this.beanInfo = this.createBeanInfo();
    }

    ExportedValuesMBean(ExportedValuesMBean extend, ExportedValue<?>[] exported, ExportedOperation[] operations) {
        this.exportedValues = new HashMap(exported.length + extend.exportedValues.size());
        this.exportedValues.putAll(extend.exportedValues);
        for (ExportedValue<?> val : exported) {
            this.exportedValues.put(val.getName(), val);
        }
        this.exportedOperations = new HashMap<String, ExportedOperation>(operations.length + extend.exportedOperations.size());
        this.exportedOperations.putAll(extend.exportedOperations);
        for (ExportedOperation op : operations) {
            this.exportedOperations.put(op.getName(), op);
        }
        this.objectName = extend.getObjectName();
        this.beanInfo = extend.beanInfo;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException {
        ExportedValue<?> result = this.exportedValues.get(name);
        if (result == null) {
            throw new AttributeNotFoundException(name);
        }
        return result.get();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        String name = attribute.getName();
        ExportedValue<?> result = this.exportedValues.get(name);
        if (result == null) {
            throw new AttributeNotFoundException(name);
        }
        result.set(attribute.getValue());
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList list = new AttributeList(names.length);
        for (String name : names) {
            list.add(new Attribute(name, this.exportedValues.get(name).get()));
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        AttributeList result = new AttributeList(list.size());
        for (Attribute attr : list.asList()) {
            ExportedValue<?> eval = this.exportedValues.get(attr.getName());
            if (eval == null) continue;
            try {
                eval.set(attr.getValue());
                result.add(attr);
            }
            catch (InvalidAttributeValueException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) {
        return this.exportedOperations.get(name).invoke(args);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    public static ObjectName createObjectName(String domain, String name) {
        try {
            String sanitizedDomain = INVALID_CHARS.matcher(domain).replaceAll("_");
            String sanitizedName = INVALID_CHARS.matcher(name).replaceAll("_");
            StringBuilder builder = new StringBuilder();
            builder.append(sanitizedDomain).append(':');
            builder.append("name=").append(sanitizedName);
            return new ObjectName(builder.toString());
        }
        catch (MalformedObjectNameException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private MBeanInfo createBeanInfo() {
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[this.exportedValues.size()];
        int i = 0;
        for (ExportedValue<?> val : this.exportedValues.values()) {
            attrs[i++] = ExportedValuesMBean.createAttributeInfo(val);
        }
        MBeanOperationInfo[] operations = new MBeanOperationInfo[this.exportedOperations.size()];
        i = 0;
        for (ExportedOperation op : this.exportedOperations.values()) {
            MBeanParameterInfo[] paramInfos = op.getParameterInfos();
            operations[i++] = new MBeanOperationInfo(op.getName(), op.getDescription(), paramInfos, op.getReturnType().getName(), 3);
        }
        return new MBeanInfo(this.getClass().getName(), "JmxMBean", attrs, null, operations, null);
    }

    private static MBeanAttributeInfo createAttributeInfo(ExportedValue<?> val) {
        Class<?> oClass = val.getValueClass();
        Class<?> valClass = Reflections.primitiveToWrapper(oClass);
        OpenType<?> openType = OpenTypeConverter.getOpenType(oClass);
        String type = Number.class.isAssignableFrom(valClass) ? Number.class.getName() : (valClass == Boolean.class || valClass == String.class ? valClass.getName() : (Enum.class.isAssignableFrom(valClass) ? String.class.getName() : openType.getTypeName()));
        return new MBeanAttributeInfo(val.getName(), type, val.getDescription(), true, val.isWriteable(), valClass == Boolean.class, new ImmutableDescriptor(new String[]{"openType", "originalType"}, new Object[]{openType, oClass.getName()}));
    }

    public String toString() {
        return "ExportedValuesMBean{exportedValues=" + this.exportedValues + ", exportedOperations=" + this.exportedOperations + ", objectName=" + this.objectName + ", beanInfo=" + this.beanInfo + '}';
    }
}

