/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Quanta
implements Comparable<Quanta>,
Serializable {
    private final long intervalStart;
    private final long intervalEnd;
    private static final long serialVersionUID = 1L;

    public Quanta(long intervalStart, long intervalEnd) {
        this.intervalStart = intervalStart;
        this.intervalEnd = intervalEnd;
    }

    public Quanta(@Nonnull String stringVariant) {
        int undLocation = stringVariant.indexOf(95);
        if (undLocation < 0) {
            throw new IllegalArgumentException("Invalid Quanta DataSource " + stringVariant);
        }
        String startStr = stringVariant.substring(1, undLocation);
        String endStr = stringVariant.substring(undLocation + 1);
        this.intervalStart = "NI".equals(startStr) ? Long.MIN_VALUE : Long.parseLong(startStr);
        this.intervalEnd = "PI".equals(endStr) ? Long.MAX_VALUE : Long.parseLong(endStr);
    }

    public long getIntervalEnd() {
        return this.intervalEnd;
    }

    public long getIntervalStart() {
        return this.intervalStart;
    }

    public long getClosestToZero() {
        return this.intervalStart < 0L ? this.intervalEnd : this.intervalStart;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(16);
        result.append('Q');
        if (this.intervalStart == Long.MIN_VALUE) {
            result.append("NI");
        } else {
            result.append(this.intervalStart);
        }
        result.append('_');
        if (this.intervalEnd == Long.MAX_VALUE) {
            result.append("PI");
        } else {
            result.append(this.intervalEnd);
        }
        return result.toString();
    }

    @Override
    public int compareTo(Quanta o) {
        if (this.intervalStart < o.intervalStart) {
            return -1;
        }
        if (this.intervalStart > o.intervalStart) {
            return 1;
        }
        if (this.intervalEnd < o.intervalEnd) {
            return -1;
        }
        if (this.intervalEnd > o.intervalEnd) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (int)(this.intervalStart ^ this.intervalStart >>> 32);
        return 89 * hash + (int)(this.intervalEnd ^ this.intervalEnd >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quanta other = (Quanta)obj;
        return this.compareTo(other) == 0;
    }
}

