/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.spf4j.perf.MeasurementRecorderSource;

@CleanupObligation
@SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
public final class MeasuredFileInputStream
extends FileInputStream {
    private final Class<?> from;
    private final File file;
    private final MeasurementRecorderSource recorderSource;

    public MeasuredFileInputStream(String name, Class<?> from, MeasurementRecorderSource recorderSource) throws FileNotFoundException {
        this(new File(name), from, recorderSource);
    }

    public MeasuredFileInputStream(File file, Class<?> from, MeasurementRecorderSource recorderSource) throws FileNotFoundException {
        super(file);
        this.from = from;
        this.recorderSource = recorderSource;
        this.file = file;
    }

    public MeasuredFileInputStream(FileDescriptor fdObj, Class<?> from, MeasurementRecorderSource recorderSource) {
        super(fdObj);
        this.from = from;
        this.recorderSource = recorderSource;
        this.file = null;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        this.recorderSource.getRecorder(this.from).record(result);
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        this.recorderSource.getRecorder(this.from).record(result);
        return result;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result >= 0) {
            this.recorderSource.getRecorder(this.from).record(1L);
        }
        return result;
    }

    public String toString() {
        return "MeasuredFileInputStream{from=" + this.from + ", file=" + this.file + ", recorderSource=" + this.recorderSource + '}';
    }
}

