/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
public final class ObjectHolder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectHolder.class);
    private T obj;
    private boolean borrowed;
    private final RecyclingSupplier.Factory<T> factory;

    ObjectHolder(RecyclingSupplier.Factory<T> factory) {
        this.factory = factory;
        this.borrowed = false;
    }

    ObjectHolder(RecyclingSupplier.Factory<T> factory, boolean lazy) throws ObjectCreationException {
        this(factory);
        if (!lazy) {
            this.obj = factory.create();
        }
    }

    ObjectHolder(T object) {
        this.factory = null;
        this.borrowed = false;
        this.obj = object;
    }

    public synchronized T getObj() {
        return this.obj;
    }

    public synchronized T borrowOrCreateObjectIfPossible() throws ObjectCreationException {
        if (this.borrowed) {
            return null;
        }
        if (this.obj == null) {
            this.obj = this.factory.create();
        }
        this.borrowed = true;
        return this.obj;
    }

    @Nullable
    public synchronized T borrowObjectIfAvailable() {
        if (this.borrowed || this.obj == null) {
            return null;
        }
        this.borrowed = true;
        return this.obj;
    }

    public synchronized void returnObject(T object, @Nullable Exception e) {
        if (!this.borrowed || object != this.obj) {
            throw new IllegalStateException("Cannot return something that was not borrowed from here " + object);
        }
        this.borrowed = false;
        if (e != null) {
            boolean isValid;
            Object vex = null;
            try {
                isValid = this.factory.validate(object, e);
            }
            catch (RuntimeException ex) {
                isValid = false;
            }
            catch (Exception ex) {
                isValid = false;
            }
            if (isValid) {
                throw new RuntimeException(e);
            }
            LOG.warn("Validation of {} failed, detail {}", new Object[]{this.obj, vex, e});
            this.obj = null;
            try {
                this.factory.dispose(object);
            }
            catch (ObjectDisposeException ex1) {
                LOG.warn("Failed to dispose {}", object, (Object)ex1);
            }
            catch (RuntimeException ex1) {
                LOG.error("Failed to dispose {}", object, (Object)ex1);
            }
        }
    }

    public synchronized void validateObjectIfNotBorrowed() throws ObjectDisposeException {
        if (!this.borrowed && this.obj != null) {
            boolean isValid;
            Object vex = null;
            try {
                isValid = this.factory.validate(this.obj, null);
            }
            catch (RuntimeException ex) {
                isValid = false;
            }
            catch (Exception ex) {
                isValid = false;
            }
            if (!isValid) {
                LOG.warn("Validation of {} failed, detail {} ", this.obj, vex);
                T object = this.obj;
                this.obj = null;
                this.factory.dispose(object);
            }
        }
    }

    public synchronized boolean disposeIfNotBorrowed() throws ObjectDisposeException {
        if (this.borrowed) {
            return false;
        }
        if (this.obj != null) {
            try {
                this.factory.dispose(this.obj);
            }
            finally {
                this.obj = null;
            }
        }
        return true;
    }

    public synchronized String toString() {
        return "ObjectHolder{obj=" + this.obj + ", borrowed=" + this.borrowed + ", factory=" + this.factory + '}';
    }
}

