/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.util.LinkedList;
import java.util.Queue;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.impl.ObjectHolder;

public final class ObjectHolderFactory<T>
implements RecyclingSupplier.Factory<ObjectHolder<T>> {
    private final Queue<ObjectHolder<T>> objects = new LinkedList<ObjectHolder<T>>();
    private final RecyclingSupplier.Factory<T> factory;

    public ObjectHolderFactory(int precreateNumber, RecyclingSupplier.Factory<T> factory) throws ObjectCreationException {
        this.factory = factory;
        for (int i = 0; i < precreateNumber; ++i) {
            this.objects.add(new ObjectHolder<T>(factory, false));
        }
    }

    public ObjectHolderFactory(RecyclingSupplier.Factory<T> factory) {
        this.factory = factory;
    }

    @Override
    public ObjectHolder<T> create() throws ObjectCreationException {
        if (this.objects.isEmpty()) {
            return new ObjectHolder<RecyclingSupplier.Factory<T>>(this.factory);
        }
        return this.objects.remove();
    }

    @Override
    public void dispose(ObjectHolder<T> object) throws ObjectDisposeException {
        if (!object.disposeIfNotBorrowed()) {
            throw new RuntimeException("Object from holder is borrowed " + object);
        }
    }

    @Override
    public boolean validate(ObjectHolder<T> object, Exception e) {
        return true;
    }

    public String toString() {
        return "ObjectHolderFactory{objects=" + this.objects + ", factory=" + this.factory + '}';
    }
}

