/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Handler;
import org.spf4j.base.Throwables;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Scanable;
import org.spf4j.recyclable.impl.ObjectHolder;

@ParametersAreNonnullByDefault
final class ObjectPoolWrapper<T>
implements RecyclingSupplier<T>,
Scanable<ObjectHolder<T>> {
    private final RecyclingSupplier<T> pool;
    private final Handler<T, ? extends Exception> borrowHook;
    private final Handler<T, ? extends Exception> returnHook;
    private static final Logger LOG = LoggerFactory.getLogger(ObjectPoolWrapper.class);

    ObjectPoolWrapper(RecyclingSupplier<T> pool, @Nullable Handler<T, ? extends Exception> borrowHook, @Nullable Handler<T, ? extends Exception> returnHook) {
        this.pool = pool;
        this.borrowHook = borrowHook;
        this.returnHook = returnHook;
        if (borrowHook == null && returnHook == null) {
            throw new IllegalArgumentException("Both hooks can't be null for " + pool);
        }
    }

    @Override
    @SuppressWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"})
    public T get() throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException {
        T result = this.pool.get();
        try {
            if (this.borrowHook != null) {
                this.borrowHook.handle(result, Long.MAX_VALUE);
            }
            return result;
        }
        catch (Exception e) {
            try {
                this.pool.recycle(result, e);
            }
            catch (RuntimeException ex) {
                throw Throwables.suppress(new RuntimeException(ex), e);
            }
            throw new ObjectBorrowException("Exception while executing borrow hook " + this.borrowHook, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(T object, Exception e) {
        try {
            if (this.returnHook != null) {
                this.returnHook.handle(object, Long.MAX_VALUE);
            }
        }
        catch (Exception ex) {
            LOG.error("Error while handling object {} ", object, (Object)ex);
        }
        finally {
            this.pool.recycle(object, e);
        }
    }

    @Override
    public boolean tryDispose(long timeoutMillis) throws ObjectDisposeException, InterruptedException {
        return this.pool.tryDispose(timeoutMillis);
    }

    @Override
    public boolean scan(Scanable.ScanHandler<ObjectHolder<T>> handler) throws Exception {
        if (this.pool instanceof Scanable) {
            return ((Scanable)((Object)this.pool)).scan(handler);
        }
        throw new RuntimeException("Wrapped pool " + this.pool + " is not scanable");
    }

    @Override
    public void recycle(T object) {
        this.pool.recycle(object);
    }

    public String toString() {
        return "ObjectPoolWrapper{pool=" + this.pool + ", borrowHook=" + this.borrowHook + ", returnHook=" + this.returnHook + '}';
    }
}

