/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Handler;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Scanable;
import org.spf4j.recyclable.impl.ObjectHolder;
import org.spf4j.recyclable.impl.ObjectPoolWrapper;
import org.spf4j.recyclable.impl.ScalableObjectPool;

public final class RecyclingSupplierBuilder<T> {
    private final int maxSize;
    private final RecyclingSupplier.Factory<T> factory;
    private boolean fair = true;
    private ScheduledExecutorService maintenanceExecutor;
    private long maintenanceIntervalMillis;
    private Handler<T, ? extends Exception> borrowHook;
    private Handler<T, ? extends Exception> returnHook;
    private int initialSize;
    private boolean collectBorrowed;

    public RecyclingSupplierBuilder(int maxSize, RecyclingSupplier.Factory<T> factory) {
        this.maxSize = maxSize;
        this.factory = factory;
        this.initialSize = 0;
    }

    public RecyclingSupplierBuilder<T> unfair() {
        this.fair = false;
        return this;
    }

    public RecyclingSupplierBuilder<T> withInitialSize(int pinitialSize) {
        this.initialSize = pinitialSize;
        return this;
    }

    public RecyclingSupplierBuilder<T> withMaintenance(ScheduledExecutorService pexec, long pmaintenanceIntervalMillis, boolean pcollectBorrowed) {
        this.maintenanceExecutor = pexec;
        this.maintenanceIntervalMillis = pmaintenanceIntervalMillis;
        this.collectBorrowed = pcollectBorrowed;
        return this;
    }

    public RecyclingSupplierBuilder<T> withGetHook(Handler<T, ? extends Exception> phook) {
        this.borrowHook = phook;
        return this;
    }

    public RecyclingSupplierBuilder<T> withRecycleHook(Handler<T, ? extends Exception> phook) {
        this.returnHook = phook;
        return this;
    }

    public RecyclingSupplier<T> build() throws ObjectCreationException {
        ScalableObjectPool<T> underlyingPool = new ScalableObjectPool<T>(this.initialSize, this.maxSize, this.factory, this.fair);
        RecyclingSupplier<T> pool = this.borrowHook != null || this.returnHook != null ? new ObjectPoolWrapper<T>(underlyingPool, this.borrowHook, this.returnHook) : underlyingPool;
        if (this.maintenanceExecutor != null) {
            this.maintenanceExecutor.scheduleWithFixedDelay(new AbstractRunnableImpl<T>(underlyingPool, this.collectBorrowed), this.maintenanceIntervalMillis, this.maintenanceIntervalMillis, TimeUnit.MILLISECONDS);
        }
        return pool;
    }

    public String toString() {
        return "RecyclingSupplierBuilder{maxSize=" + this.maxSize + ", factory=" + this.factory + ", fair=" + this.fair + ", maintenanceExecutor=" + this.maintenanceExecutor + ", maintenanceIntervalMillis=" + this.maintenanceIntervalMillis + ", borrowHook=" + this.borrowHook + ", returnHook=" + this.returnHook + ", initialSize=" + this.initialSize + ", collectBorrowed=" + this.collectBorrowed + '}';
    }

    static final class AbstractRunnableImpl<T>
    extends AbstractRunnable {
        private final ScalableObjectPool<T> underlyingPool;
        private final boolean collectBorrowed;

        AbstractRunnableImpl(ScalableObjectPool<T> underlyingPool, boolean collectBorrowed) {
            super(true);
            this.underlyingPool = underlyingPool;
            this.collectBorrowed = collectBorrowed;
        }

        @Override
        public void doRun() throws Exception {
            if (this.collectBorrowed) {
                this.underlyingPool.requestReturnFromBorrowersIfNotInUse();
            }
            this.underlyingPool.scan(new Scanable.ScanHandler<ObjectHolder<T>>(){

                @Override
                public boolean handle(ObjectHolder<T> object) throws ObjectDisposeException {
                    object.validateObjectIfNotBorrowed();
                    return true;
                }
            });
        }
    }
}

