/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.spf4j.base.ReferenceType;
import org.spf4j.recyclable.SizedRecyclingSupplier;

public final class SizedThreadLocalRecyclingSupplier<T>
implements SizedRecyclingSupplier<T> {
    private final SizedRecyclingSupplier.Factory<T> factory;
    private final ReferenceType refType;
    private final ThreadLocal<NavigableMap<Integer, Collection<Reference<T>>>> localObjects;

    public SizedThreadLocalRecyclingSupplier(SizedRecyclingSupplier.Factory<T> factory, ReferenceType refType) {
        this.factory = factory;
        this.refType = refType;
        this.localObjects = new ThreadLocal<NavigableMap<Integer, Collection<Reference<T>>>>(){

            @Override
            protected NavigableMap<Integer, Collection<Reference<T>>> initialValue() {
                return new TreeMap();
            }
        };
    }

    @Override
    public T get(int size) {
        NavigableMap<Integer, Collection<Reference<T>>> available = this.localObjects.get();
        if (available.isEmpty()) {
            return this.factory.create(size);
        }
        Iterator<Collection<Reference<T>>> iterator = available.tailMap(size).values().iterator();
        while (iterator.hasNext()) {
            Collection<Reference<T>> refs = iterator.next();
            for (Reference<T> next : refs) {
                T value = next.get();
                iterator.remove();
                if (value == null) continue;
                return value;
            }
            if (!refs.isEmpty()) continue;
            iterator.remove();
        }
        iterator = available.headMap(size).values().iterator();
        boolean done = false;
        while (!done && iterator.hasNext()) {
            Collection<Reference<T>> refs = iterator.next();
            for (Reference<T> next : refs) {
                T value = next.get();
                iterator.remove();
                if (value == null) continue;
                done = true;
                break;
            }
            if (!refs.isEmpty()) continue;
            iterator.remove();
        }
        return this.factory.create(size);
    }

    @Override
    public void recycle(T object) {
        Integer size;
        NavigableMap<Integer, Collection<Reference<T>>> available = this.localObjects.get();
        ArrayList<Reference<T>> refs = (ArrayList<Reference<T>>)available.get(size = Integer.valueOf(this.factory.size(object)));
        if (refs == null) {
            refs = new ArrayList<Reference<T>>(2);
            available.put(size, refs);
        }
        refs.add(this.refType.create(object));
    }

    public String toString() {
        return "SizedThreadLocalRecyclingSupplier{factory=" + this.factory + ", refType=" + (Object)((Object)this.refType) + '}';
    }
}

