/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import java.io.Serializable;
import java.util.Objects;
import org.spf4j.base.Method;

public final class InvokedMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int invocationId;
    private final Method method;
    public static final InvokedMethod ROOT = new InvokedMethod(Method.ROOT, 0);

    public InvokedMethod(Method method, int invocationId) {
        this.method = method;
        this.invocationId = invocationId;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.invocationId;
        return 47 * hash + Objects.hashCode(this.method);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvokedMethod other = (InvokedMethod)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        return this.invocationId == other.invocationId;
    }

    public Method getMethod() {
        return this.method;
    }

    public InvokedMethod withId(int pid) {
        return new InvokedMethod(this.method, pid);
    }

    public InvokedMethod withNewId() {
        return new InvokedMethod(this.method, this.invocationId + 1);
    }

    public String toString() {
        return "InvokedMethod{invocationId=" + this.invocationId + ", method=" + this.method + '}';
    }
}

