/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.spf4j.base.ArrayBuilder;
import org.spf4j.stackmonitor.AbstractStackCollector;
import org.spf4j.stackmonitor.FastStackCollector;

@Beta
public final class ObservableOnlyStackCollector
extends AbstractStackCollector {
    private final ConcurrentMap<Thread, Consumer<StackTraceElement[]>> stConsumers;
    private ArrayBuilder<Thread> requestFor = new ArrayBuilder<Thread>(8, Thread.class);

    public ObservableOnlyStackCollector() {
        this.stConsumers = new ConcurrentHashMap<Thread, Consumer<StackTraceElement[]>>();
    }

    @Nullable
    public Consumer<StackTraceElement[]> registerConsumer(Thread thread, Consumer<StackTraceElement[]> consumer) {
        return this.stConsumers.put(thread, consumer);
    }

    public Consumer<StackTraceElement[]> unregisterConsumer(Thread thread) {
        return (Consumer)this.stConsumers.remove(thread);
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void sample(Thread ignore) {
        this.requestFor.clear();
        for (Thread t : this.stConsumers.keySet()) {
            this.requestFor.add(t);
        }
        Thread[] rfArray = this.requestFor.getArray();
        StackTraceElement[][] stackDump = FastStackCollector.getStackTraces(rfArray);
        int size = this.requestFor.getSize();
        for (int i = 0; i < size; ++i) {
            Thread t = rfArray[i];
            StackTraceElement[] stackTrace = stackDump[i];
            Consumer consumer = (Consumer)this.stConsumers.get(t);
            if (consumer != null) {
                consumer.accept(stackTrace);
            }
            if (stackTrace != null && stackTrace.length > 0) {
                this.addSample(stackTrace);
                continue;
            }
            this.addSample(new StackTraceElement[]{new StackTraceElement("Thread", t.getName(), "", 0)});
        }
    }
}

