/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.trace.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.spf4j.trace.avro.ASpanRecord;

@AvroGenerated
public class ATraceRecord
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 2472619899346700911L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ATraceRecord\",\"namespace\":\"org.spf4j.trace.avro\",\"doc\":\"record representing the samples where a particular method was executed\",\"fields\":[{\"name\":\"traceId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"the id of the Trace\"},{\"name\":\"spans\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"ASpanRecord\",\"doc\":\"record representing all java methods with the same name from a particular class.\",\"fields\":[{\"name\":\"startTime\",\"type\":\"long\",\"doc\":\"start time, millis since epoch\",\"default\":-1},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"end time, millis since epoch, -1 if end is not known in this record\",\"default\":-1},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"the name of the span or \\\"\\\" if not available\",\"default\":\"\"},{\"name\":\"spanId\",\"type\":\"int\",\"doc\":\"the span id, 0 is the root span id of a trace\"},{\"name\":\"annotations\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"ATraceAnnotation\",\"doc\":\"Trace Annotation\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"the timestamp\"},{\"name\":\"values\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"ANameValue\",\"fields\":[{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"the name\"},{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"the value\"},{\"name\":\"type\",\"type\":{\"type\":\"enum\",\"name\":\"ValueType\",\"symbols\":[\"JSON\",\"BASE64BIN\",\"PLAIN\"]},\"default\":\"PLAIN\"}]}},\"doc\":\"values\",\"default\":[]}]}},\"doc\":\"the parent span Id, -1 if this is the root span;\\n      int parentSpanId;\\n      /** trace annotations\",\"default\":[]},{\"name\":\"samples\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"ASample\",\"namespace\":\"org.spf4j.ssdump2.avro\",\"doc\":\"record representing the samples where a particular method was executed\",\"fields\":[{\"name\":\"id\",\"type\":\"int\",\"doc\":\"the id of the sample\"},{\"name\":\"parentId\",\"type\":\"int\",\"doc\":\"the parent sample where current method was executed from.\"},{\"name\":\"count\",\"type\":\"int\",\"doc\":\"the number of time this records method has been caught in execution\"},{\"name\":\"method\",\"type\":{\"type\":\"record\",\"name\":\"AMethod\",\"doc\":\"record representing all java methods with the same name from a particular class.\",\"fields\":[{\"name\":\"declaringClass\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"the declaring class of the method.\"},{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"the name of the method\"}]},\"doc\":\"the method caught in execution\"}]}},\"doc\":\"profile samples associated with trace\",\"default\":[]}]}},\"doc\":\"the span detail captured in this record\",\"default\":[]}]}");
    @Deprecated
    public String traceId;
    @Deprecated
    public List<ASpanRecord> spans;
    private static final DatumWriter WRITER$ = new SpecificDatumWriter(SCHEMA$);
    private static final DatumReader READER$ = new SpecificDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public ATraceRecord() {
    }

    public ATraceRecord(String traceId, List<ASpanRecord> spans) {
        this.traceId = traceId;
        this.spans = spans;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.traceId;
            }
            case 1: {
                return this.spans;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.traceId = (String)value$;
                break;
            }
            case 1: {
                this.spans = (List)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String value) {
        this.traceId = value;
    }

    public List<ASpanRecord> getSpans() {
        return this.spans;
    }

    public void setSpans(List<ASpanRecord> value) {
        this.spans = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(ATraceRecord other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<ATraceRecord>
    implements RecordBuilder<ATraceRecord> {
        private String traceId;
        private List<ASpanRecord> spans;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.traceId)) {
                this.traceId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.traceId);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.spans)) {
                this.spans = (List)this.data().deepCopy(this.fields()[1].schema(), other.spans);
                this.fieldSetFlags()[1] = true;
            }
        }

        private Builder(ATraceRecord other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.traceId)) {
                this.traceId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.traceId);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.spans)) {
                this.spans = (List)this.data().deepCopy(this.fields()[1].schema(), other.spans);
                this.fieldSetFlags()[1] = true;
            }
        }

        public String getTraceId() {
            return this.traceId;
        }

        public Builder setTraceId(String value) {
            this.validate(this.fields()[0], value);
            this.traceId = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTraceId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTraceId() {
            this.traceId = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public List<ASpanRecord> getSpans() {
            return this.spans;
        }

        public Builder setSpans(List<ASpanRecord> value) {
            this.validate(this.fields()[1], value);
            this.spans = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasSpans() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearSpans() {
            this.spans = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public ATraceRecord build() {
            try {
                ATraceRecord record = new ATraceRecord();
                record.traceId = this.fieldSetFlags()[0] ? this.traceId : (String)this.defaultValue(this.fields()[0]);
                record.spans = this.fieldSetFlags()[1] ? this.spans : (List)this.defaultValue(this.fields()[1]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

