/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import com.sun.nio.file.SensitivityWatchEventModifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.spf4j.base.Either;
import org.spf4j.base.Handler;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.io.MemorizingBufferedInputStream;
import org.spf4j.tsdb2.TSDBWriter;
import org.spf4j.tsdb2.avro.DataBlock;
import org.spf4j.tsdb2.avro.Header;
import org.spf4j.tsdb2.avro.TableDef;

@SuppressFBWarnings(value={"IICU_INCORRECT_INTERNAL_CLASS_USE"})
public final class TSDBReader
implements Closeable {
    private final MemorizingBufferedInputStream bis;
    private final Header header;
    private long size;
    private final BinaryDecoder decoder;
    private final SpecificDatumReader<Object> recordReader;
    private RandomAccessFile raf;
    private final File file;
    private static final boolean CORUPTION_LENIENT = Boolean.getBoolean("spf4j.tsdb2.lenientRead");
    private volatile boolean watch;

    public TSDBReader(File file, int bufferSize) throws IOException {
        this.file = file;
        FileInputStream fis = new FileInputStream(file);
        this.bis = new MemorizingBufferedInputStream(fis);
        SpecificDatumReader reader = new SpecificDatumReader(Header.getClassSchema());
        this.decoder = DecoderFactory.get().directBinaryDecoder((InputStream)this.bis, null);
        TSDBWriter.validateType(this.bis);
        DataInputStream dis = new DataInputStream(this.bis);
        this.size = dis.readLong();
        this.header = (Header)((Object)reader.read(null, (Decoder)this.decoder));
        this.recordReader = new SpecificDatumReader(new Schema.Parser().parse(this.header.getContentSchema()), Schema.createUnion(Arrays.asList(TableDef.SCHEMA$, DataBlock.SCHEMA$)));
    }

    public synchronized boolean reReadSize() throws IOException {
        if (this.raf == null) {
            this.raf = new RandomAccessFile(this.file, "r");
        }
        this.raf.seek(TSDBWriter.MAGIC.length);
        long old = this.size;
        this.size = this.raf.readLong();
        return this.size != old;
    }

    @Nullable
    public synchronized Either<TableDef, DataBlock> read() throws IOException {
        Object result;
        long position = this.bis.getReadBytes();
        if (position >= this.size) {
            return null;
        }
        try {
            result = this.recordReader.read(null, (Decoder)this.decoder);
        }
        catch (IOException | RuntimeException ex) {
            if (CORUPTION_LENIENT) {
                return null;
            }
            throw ex;
        }
        if (result instanceof TableDef) {
            TableDef td = (TableDef)((Object)result);
            if (position != td.id) {
                throw new IOException("Table Id should be equal with file position " + position + ", " + td.id);
            }
            return Either.left(td);
        }
        return Either.right((DataBlock)((Object)result));
    }

    @Override
    public synchronized void close() throws IOException {
        try (MemorizingBufferedInputStream is = this.bis;){
            if (this.raf != null) {
                this.raf.close();
            }
        }
    }

    public synchronized long getSize() {
        return this.size;
    }

    public Header getHeader() {
        return this.header;
    }

    public void stopWatching() {
        this.watch = false;
    }

    public synchronized <E extends Exception> Future<Void> bgWatch(final Handler<Either<TableDef, DataBlock>, E> handler, final EventSensitivity es) {
        return DefaultExecutor.INSTANCE.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TSDBReader.this.watch(handler, es);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NOS_NON_OWNED_SYNCHRONIZATION"})
    public <E extends Exception> void watch(Handler<Either<TableDef, DataBlock>, E> handler, EventSensitivity es) throws IOException, InterruptedException, E {
        SensitivityWatchEventModifier sensitivity;
        TSDBReader tSDBReader = this;
        synchronized (tSDBReader) {
            if (this.watch) {
                throw new IllegalStateException("File is already watched " + this.file);
            }
            this.watch = true;
        }
        switch (es) {
            case LOW: {
                sensitivity = SensitivityWatchEventModifier.LOW;
                break;
            }
            case MEDIUM: {
                sensitivity = SensitivityWatchEventModifier.MEDIUM;
                break;
            }
            case HIGH: {
                sensitivity = SensitivityWatchEventModifier.HIGH;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported sensitivity " + (Object)((Object)es));
            }
        }
        Path path = this.file.getParentFile().toPath();
        try (WatchService watchService = path.getFileSystem().newWatchService();){
            path.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW}, sensitivity);
            this.readAll(handler);
            do {
                WatchKey key;
                if ((key = watchService.poll(1000L, TimeUnit.MILLISECONDS)) == null) {
                    if (!this.reReadSize()) continue;
                    this.readAll(handler);
                    continue;
                }
                if (!key.isValid()) {
                    key.cancel();
                } else {
                    if (!key.pollEvents().isEmpty() && this.reReadSize()) {
                        this.readAll(handler);
                    }
                    if (key.reset()) continue;
                    key.cancel();
                }
                break;
            } while (this.watch);
        }
        finally {
            this.watch = false;
        }
    }

    public synchronized <E extends Exception> void readAll(Handler<Either<TableDef, DataBlock>, E> handler) throws IOException, E {
        Either<TableDef, DataBlock> data;
        while ((data = this.read()) != null) {
            handler.handle(data, Long.MAX_VALUE);
        }
    }

    public String toString() {
        return "TSDBReader{size=" + this.size + ", raf=" + this.raf + ", file=" + this.file + '}';
    }

    public static enum EventSensitivity {
        HIGH,
        MEDIUM,
        LOW;

    }
}

