/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.util.concurrent.UncheckedExecutionException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.base.SysExits;
import org.spf4j.base.Throwables;

public abstract class AbstractRunnable
implements Runnable {
    @Deprecated
    public static final int ERROR_EXIT_CODE = SysExits.EX_SOFTWARE.exitCode();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRunnable.class);
    public static final Runnable NOP = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final boolean lenient;
    private final String threadName;

    public AbstractRunnable(boolean lenient, @Nullable String threadName) {
        this.lenient = lenient;
        this.threadName = threadName;
    }

    public AbstractRunnable(boolean lenient) {
        this(lenient, null);
    }

    public AbstractRunnable() {
        this(false, null);
    }

    public AbstractRunnable(String threadName) {
        this(false, threadName);
    }

    @Override
    public final void run() {
        block12: {
            Thread thread = null;
            String origName = null;
            if (this.threadName != null) {
                thread = Thread.currentThread();
                origName = thread.getName();
                thread.setName(this.threadName);
            }
            try {
                this.doRun();
            }
            catch (Exception ex) {
                if (Throwables.containsNonRecoverable(ex)) {
                    Runtime.goDownWithError((Throwable)ex, SysExits.EX_SOFTWARE);
                }
                if (this.lenient) {
                    LOGGER.error("Exception in runnable: ", (Throwable)ex);
                    break block12;
                }
                throw new UncheckedExecutionException((Throwable)ex);
            }
            catch (Throwable ex) {
                if (Throwables.containsNonRecoverable(ex)) {
                    Runtime.goDownWithError(ex, SysExits.EX_SOFTWARE);
                }
                throw ex;
            }
            finally {
                if (thread != null) {
                    thread.setName(origName);
                }
            }
        }
    }

    public abstract void doRun() throws Exception;
}

