/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ObjectArrays;
import java.util.Objects;

@GwtCompatible
public final class Arrays {
    public static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int ARR_CPY_THR = 128;

    private Arrays() {
    }

    public static double[] getColumnAsDoubles(long[][] data, int columnNumber) {
        double[] result = new double[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data[i][columnNumber];
        }
        return result;
    }

    public static double[] getColumn(double[][] data, int columnNumber) {
        double[] result = new double[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data[i][columnNumber];
        }
        return result;
    }

    public static double[] toDoubleArray(long ... larr) {
        double[] result = new double[larr.length];
        for (int i = 0; i < larr.length; ++i) {
            result[i] = larr[i];
        }
        return result;
    }

    public static Object[] toObjectArray(long ... larr) {
        Object[] result = new Object[larr.length];
        for (int i = 0; i < larr.length; ++i) {
            result[i] = larr[i];
        }
        return result;
    }

    public static double[] divide(double[] arr1, double[] arr2) {
        double[] result = new double[arr1.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = arr1[i] / arr2[i];
        }
        return result;
    }

    public static boolean deepEquals(Object[] a1, Object[] a2, int starting) {
        return Arrays.deepEquals(a1, a2, starting, a1.length);
    }

    public static boolean deepEquals(Object[] a1, Object[] a2, int starting, int ending) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        for (int i = starting; i < ending; ++i) {
            if (Objects.deepEquals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static int search(char[] array, char c) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] moveOfRange(T[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = ObjectArrays.newArray((Object[])original, (int)newLength);
        int i = from;
        int j = 0;
        while (i < to) {
            copy[j] = original[i];
            original[i] = null;
            ++i;
            ++j;
        }
        return copy;
    }

    public static <T> T[] concat(T[] ... arrays) {
        if (arrays.length < 2) {
            throw new IllegalArgumentException("You should concatenate at least 2 arrays: " + java.util.Arrays.deepToString(arrays));
        }
        int newLength = 0;
        for (T[] arr : arrays) {
            newLength += arr.length;
        }
        Object[] result = ObjectArrays.newArray((Object[])arrays[0], (int)newLength);
        int destIdx = 0;
        for (T[] arr : arrays) {
            System.arraycopy(arr, 0, result, destIdx, arr.length);
            destIdx += arr.length;
        }
        return result;
    }

    public static <T> int indexOf(T[] array, T content) {
        int result = -1;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(content)) continue;
            return i;
        }
        return result;
    }

    @Beta
    public static void fill(byte[] array, int startIdx, int endIdx, byte value) {
        int len = endIdx - startIdx;
        if (len > 0) {
            if (endIdx > array.length || startIdx < 0) {
                throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
            }
            if (len <= 128) {
                for (int i = startIdx; i < endIdx; ++i) {
                    array[i] = value;
                }
            } else {
                int i;
                int fillEnd = startIdx + 128;
                for (i = startIdx; i < fillEnd; ++i) {
                    array[i] = value;
                }
                array[startIdx] = value;
                for (i = 128; i < len; i += i) {
                    int lmi = len - i;
                    int from = startIdx + i;
                    if (lmi < i) {
                        if (lmi < 128) {
                            int xe = from + lmi;
                            for (int j = from; j < xe; ++j) {
                                array[j] = value;
                            }
                            continue;
                        }
                        System.arraycopy(array, startIdx, array, from, lmi);
                        continue;
                    }
                    System.arraycopy(array, startIdx, array, from, i);
                }
            }
        } else if (len < 0) {
            throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
        }
    }

    @Beta
    public static <T> void fill(T[] array, int startIdx, int endIdx, T value) {
        int len = endIdx - startIdx;
        if (len > 0) {
            if (endIdx > array.length || startIdx < 0) {
                throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
            }
            if (len <= 128) {
                for (int i = startIdx; i < endIdx; ++i) {
                    array[i] = value;
                }
            } else {
                int i;
                int fillEnd = startIdx + 128;
                for (i = startIdx; i < fillEnd; ++i) {
                    array[i] = value;
                }
                array[startIdx] = value;
                for (i = 128; i < len; i += i) {
                    int lmi = len - i;
                    int from = startIdx + i;
                    if (lmi < i) {
                        if (lmi < 128) {
                            int xe = from + lmi;
                            for (int j = from; j < xe; ++j) {
                                array[j] = value;
                            }
                            continue;
                        }
                        System.arraycopy(array, startIdx, array, from, lmi);
                        continue;
                    }
                    System.arraycopy(array, startIdx, array, from, i);
                }
            }
        } else if (len < 0) {
            throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
        }
    }

    @Beta
    public static void fill(char[] array, int startIdx, int endIdx, char value) {
        int len = endIdx - startIdx;
        if (len > 0) {
            if (endIdx > array.length || startIdx < 0) {
                throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
            }
            if (len <= 128) {
                for (int i = startIdx; i < endIdx; ++i) {
                    array[i] = value;
                }
            } else {
                int i;
                int fillEnd = startIdx + 128;
                for (i = startIdx; i < fillEnd; ++i) {
                    array[i] = value;
                }
                array[startIdx] = value;
                for (i = 128; i < len; i += i) {
                    int lmi = len - i;
                    int from = startIdx + i;
                    if (lmi < i) {
                        if (lmi < 128) {
                            int xe = from + lmi;
                            for (int j = from; j < xe; ++j) {
                                array[j] = value;
                            }
                            continue;
                        }
                        System.arraycopy(array, startIdx, array, from, lmi);
                        continue;
                    }
                    System.arraycopy(array, startIdx, array, from, i);
                }
            }
        } else if (len < 0) {
            throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
        }
    }

    @Beta
    public static void fill(int[] array, int startIdx, int endIdx, int value) {
        int len = endIdx - startIdx;
        if (len > 0) {
            if (endIdx > array.length || startIdx < 0) {
                throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
            }
            if (len <= 128) {
                for (int i = startIdx; i < endIdx; ++i) {
                    array[i] = value;
                }
            } else {
                int i;
                int fillEnd = startIdx + 128;
                for (i = startIdx; i < fillEnd; ++i) {
                    array[i] = value;
                }
                array[startIdx] = value;
                for (i = 128; i < len; i += i) {
                    int lmi = len - i;
                    int from = startIdx + i;
                    if (lmi < i) {
                        if (lmi < 128) {
                            int xe = from + lmi;
                            for (int j = from; j < xe; ++j) {
                                array[j] = value;
                            }
                            continue;
                        }
                        System.arraycopy(array, startIdx, array, from, lmi);
                        continue;
                    }
                    System.arraycopy(array, startIdx, array, from, i);
                }
            }
        } else if (len < 0) {
            throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
        }
    }

    @Beta
    public static void fill(long[] array, int startIdx, int endIdx, long value) {
        int len = endIdx - startIdx;
        if (len > 0) {
            if (endIdx > array.length || startIdx < 0) {
                throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
            }
            if (len <= 128) {
                for (int i = startIdx; i < endIdx; ++i) {
                    array[i] = value;
                }
            } else {
                int i;
                int fillEnd = startIdx + 128;
                for (i = startIdx; i < fillEnd; ++i) {
                    array[i] = value;
                }
                array[startIdx] = value;
                for (i = 128; i < len; i += i) {
                    int lmi = len - i;
                    int from = startIdx + i;
                    if (lmi < i) {
                        if (lmi < 128) {
                            int xe = from + lmi;
                            for (int j = from; j < xe; ++j) {
                                array[j] = value;
                            }
                            continue;
                        }
                        System.arraycopy(array, startIdx, array, from, lmi);
                        continue;
                    }
                    System.arraycopy(array, startIdx, array, from, i);
                }
            }
        } else if (len < 0) {
            throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
        }
    }

    @Beta
    public static void fill(double[] array, int startIdx, int endIdx, double value) {
        int len = endIdx - startIdx;
        if (len > 0) {
            if (endIdx > array.length || startIdx < 0) {
                throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
            }
            if (len <= 128) {
                for (int i = startIdx; i < endIdx; ++i) {
                    array[i] = value;
                }
            } else {
                int i;
                int fillEnd = startIdx + 128;
                for (i = startIdx; i < fillEnd; ++i) {
                    array[i] = value;
                }
                array[startIdx] = value;
                for (i = 128; i < len; i += i) {
                    int lmi = len - i;
                    int from = startIdx + i;
                    if (lmi < i) {
                        if (lmi < 128) {
                            int xe = from + lmi;
                            for (int j = from; j < xe; ++j) {
                                array[j] = value;
                            }
                            continue;
                        }
                        System.arraycopy(array, startIdx, array, from, lmi);
                        continue;
                    }
                    System.arraycopy(array, startIdx, array, from, i);
                }
            }
        } else if (len < 0) {
            throw new IllegalArgumentException("Illegal range from " + startIdx + " to " + endIdx);
        }
    }
}

