/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.Beta;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Callables;

@ParametersAreNonnullByDefault
@Beta
public final class CallablesNano {
    private CallablesNano() {
    }

    public static <T, EX extends Exception> T executeWithRetry(NanoTimeoutCallable<T, EX> what, int nrImmediateRetries, long maxRetryWaitNanos, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        return CallablesNano.executeWithRetry(what, nrImmediateRetries, maxRetryWaitNanos, TimeoutNanoRetryPredicate.NORETRY_FOR_RESULT, Callables.DEFAULT_EXCEPTION_RETRY, exceptionClass);
    }

    public static <T, EX extends Exception> T executeWithRetry(NanoTimeoutCallable<T, EX> what, int nrImmediateRetries, long maxRetryWaitNanos, Callables.AdvancedRetryPredicate<Exception> retryOnException, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        return CallablesNano.executeWithRetry(what, nrImmediateRetries, maxRetryWaitNanos, TimeoutNanoRetryPredicate.NORETRY_FOR_RESULT, retryOnException, exceptionClass);
    }

    public static <T, EX extends Exception> T executeWithRetry(NanoTimeoutCallable<T, EX> what, int nrImmediateRetries, long maxWaitNanos, TimeoutNanoRetryPredicate<? super T, T> retryOnReturnVal, Callables.AdvancedRetryPredicate<Exception> retryOnException, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        long deadline = what.getDeadline();
        return Callables.executeWithRetry(what, new Callables.TimeoutRetryPredicate2RetryPredicate<T, T>(deadline, retryOnReturnVal), new Callables.FibonacciBackoffRetryPredicate(retryOnException, nrImmediateRetries, maxWaitNanos / 100L, maxWaitNanos, Callables::rootClass, deadline, () -> System.nanoTime(), TimeUnit.NANOSECONDS), exceptionClass);
    }

    public static long toDeadlineNanos(long timeoutNanos) {
        long nanoTime = System.nanoTime();
        return Callables.overflowSafeAdd(nanoTime, timeoutNanos);
    }

    public static <T, EX extends Exception> T executeWithRetry(NanoTimeoutCallable<T, EX> what, TimeoutNanoRetryPredicate<T, T> retryOnReturnVal, TimeoutNanoRetryPredicate<Exception, T> retryOnException, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        return Callables.executeWithRetry(what, retryOnReturnVal, retryOnException, exceptionClass);
    }

    public static <T, EX extends Exception> T executeWithRetry(NanoTimeoutCallable<T, EX> what, TimeoutNanoRetryPredicate<Exception, T> retryOnException, Class<EX> exceptionClass) throws InterruptedException, EX, TimeoutException {
        return Callables.executeWithRetry(what, Callables.TimeoutRetryPredicate.NORETRY_FOR_RESULT, retryOnException, exceptionClass);
    }

    public static interface TimeoutNanoRetryPredicate<T, R>
    extends Callables.TimeoutRetryPredicate<T, R> {
        public static final TimeoutNanoRetryPredicate NORETRY_FOR_RESULT = new TimeoutNanoRetryPredicate<Object, Object>(){

            @Override
            public Callables.RetryDecision<Object> getDecision(Object value, long deadline, Callable<Object> what) {
                return Callables.RetryDecision.abort();
            }
        };

        @Override
        public Callables.RetryDecision<R> getDecision(T var1, long var2, Callable<R> var4);
    }

    public static abstract class NanoTimeoutCallable<T, EX extends Exception>
    extends Callables.TimeoutCallable<T, EX> {
        public NanoTimeoutCallable(long timeoutNanos) {
            super(CallablesNano.toDeadlineNanos(timeoutNanos));
        }

        @Override
        public abstract T call(long var1) throws EX, InterruptedException, TimeoutException;
    }
}

