/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Callables;
import org.spf4j.base.CallablesNano;

@ParametersAreNonnullByDefault
@Beta
public final class CallablesNanoNonInterrupt {
    private CallablesNanoNonInterrupt() {
    }

    public static <T, EX extends Exception> T executeWithRetry(CallablesNano.NanoTimeoutCallable<T, EX> what, int nrImmediateRetries, long maxRetryWaitNanos, Class<EX> exceptionClass) throws EX {
        return CallablesNanoNonInterrupt.executeWithRetry(what, nrImmediateRetries, maxRetryWaitNanos, CallablesNano.TimeoutNanoRetryPredicate.NORETRY_FOR_RESULT, Callables.DEFAULT_EXCEPTION_RETRY, exceptionClass);
    }

    public static <T, EX extends Exception> T executeWithRetry(CallablesNano.NanoTimeoutCallable<T, EX> what, int nrImmediateRetries, long maxRetryWaitNanos, Callables.AdvancedRetryPredicate<Exception> retryOnException, Class<EX> exceptionClass) throws EX {
        return CallablesNanoNonInterrupt.executeWithRetry(what, nrImmediateRetries, maxRetryWaitNanos, CallablesNano.TimeoutNanoRetryPredicate.NORETRY_FOR_RESULT, retryOnException, exceptionClass);
    }

    public static <T, EX extends Exception> T executeWithRetry(CallablesNano.NanoTimeoutCallable<T, EX> what, int nrImmediateRetries, long maxWaitNanos, CallablesNano.TimeoutNanoRetryPredicate<? super T, T> retryOnReturnVal, Callables.AdvancedRetryPredicate<Exception> retryOnException, Class<EX> exceptionClass) throws EX {
        long deadline = what.getDeadline();
        try {
            return Callables.executeWithRetry(what, new Callables.TimeoutRetryPredicate2RetryPredicate<T, T>(deadline, retryOnReturnVal), new Callables.FibonacciBackoffRetryPredicate(retryOnException, nrImmediateRetries, maxWaitNanos / 100L, maxWaitNanos, Callables::rootClass, deadline, () -> System.nanoTime(), TimeUnit.NANOSECONDS), exceptionClass);
        }
        catch (InterruptedException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
        catch (TimeoutException ex) {
            throw new UncheckedTimeoutException((Throwable)ex);
        }
    }

    public static <T, EX extends Exception> T executeWithRetry(CallablesNano.NanoTimeoutCallable<T, EX> what, CallablesNano.TimeoutNanoRetryPredicate<T, T> retryOnReturnVal, CallablesNano.TimeoutNanoRetryPredicate<Exception, T> retryOnException, Class<EX> exceptionClass) throws EX {
        try {
            return Callables.executeWithRetry(what, retryOnReturnVal, retryOnException, exceptionClass);
        }
        catch (InterruptedException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
        catch (TimeoutException ex) {
            throw new UncheckedTimeoutException((Throwable)ex);
        }
    }

    public static <T, EX extends Exception> T executeWithRetry(CallablesNano.NanoTimeoutCallable<T, EX> what, CallablesNano.TimeoutNanoRetryPredicate<Exception, T> retryOnException, Class<EX> exceptionClass) throws EX {
        try {
            return Callables.executeWithRetry(what, Callables.TimeoutRetryPredicate.NORETRY_FOR_RESULT, retryOnException, exceptionClass);
        }
        catch (InterruptedException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
        catch (TimeoutException ex) {
            throw new UncheckedTimeoutException((Throwable)ex);
        }
    }
}

