/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.util.Arrays;

public final class Comparables {
    private Comparables() {
    }

    public static <T> Comparable<T> min(Object ... nrs) {
        if (nrs.length == 0) {
            throw new IllegalArgumentException("cannot calc min of empty array" + Arrays.toString(nrs));
        }
        Comparable min = (Comparable)nrs[0];
        for (int i = 1; i < nrs.length; ++i) {
            Comparable c = (Comparable)nrs[i];
            if (c.compareTo(min) >= 0) continue;
            min = c;
        }
        return min;
    }

    public static <T> Comparable<T> max(Object ... nrs) {
        if (nrs.length == 0) {
            throw new IllegalArgumentException("cannot calc max of empty array: " + Arrays.toString(nrs));
        }
        Comparable max = (Comparable)nrs[0];
        for (int i = 1; i < nrs.length; ++i) {
            Comparable c = (Comparable)nrs[i];
            if (c.compareTo(max) <= 0) continue;
            max = c;
        }
        return max;
    }

    public static <T extends Comparable<T>> int compare(T first, T second) {
        if (first == null) {
            return second == null ? 0 : 1;
        }
        return second == null ? -1 : first.compareTo(second);
    }

    public static <T extends Comparable<T>> int compareArrays(T[] first, T[] second) {
        int result = 0;
        if (first == second) {
            return result;
        }
        int i = 0;
        int l1 = first.length;
        int l2 = second.length;
        int n = Math.min(l1, l2);
        if (n == 0) {
            return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        }
        while ((result = Comparables.compare(first[i], second[i])) == 0 && ++i < n) {
        }
        if (result == 0 && l1 != l2) {
            return l1 < l2 ? -1 : 1;
        }
        return result;
    }

    public static <T extends Comparable<T>> int compareArrays(T[] first, T[] second, int from, int to) {
        int result = 0;
        if (first == second) {
            return result;
        }
        int n = to;
        int i = from;
        if (n == i) {
            return 0;
        }
        while ((result = Comparables.compare(first[i], second[i])) == 0 && ++i < n) {
        }
        return result;
    }
}

