/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.MutableHolder;
import org.spf4j.base.Throwables;

@ParametersAreNonnullByDefault
public final class Iterables {
    private Iterables() {
    }

    @Nullable
    @CheckReturnValue
    public static <T> RuntimeException forAll(Iterable<T> itterable, final Consumer<? super T> consumer) {
        final MutableHolder<Object> hex = MutableHolder.of(null);
        itterable.forEach(new Consumer<T>(){

            @Override
            public void accept(T t) {
                try {
                    consumer.accept(t);
                }
                catch (RuntimeException ex1) {
                    RuntimeException ex = (RuntimeException)hex.getValue();
                    if (ex == null) {
                        hex.setValue(ex1);
                    }
                    hex.setValue(Throwables.suppress(ex1, ex));
                }
            }
        });
        return hex.getValue();
    }

    public static <T> void forAll2(Iterable<T> itterable, Consumer<? super T> consumer) {
        RuntimeException ex = Iterables.forAll(itterable, consumer);
        if (ex != null) {
            throw ex;
        }
    }
}

