/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spf4j.base.Writeable;
import org.spf4j.io.Csv;

public class Pair<A, B>
implements Map.Entry<A, B>,
Writeable {
    @Nullable
    protected final A first;
    @Nullable
    protected final B second;

    @ConstructorProperties(value={"first", "second"})
    public Pair(@Nullable A first, @Nullable B second) {
        this.first = first;
        this.second = second;
    }

    public static <A, B> Pair<A, B> of(@Nullable A first, @Nullable B second) {
        return new Pair<A, B>(first, second);
    }

    @Nullable
    public static Pair<String, String> from(@Nonnull String stringPair) {
        if (stringPair.isEmpty()) {
            return null;
        }
        int commaIdx = stringPair.indexOf(44);
        if (commaIdx < 0) {
            return null;
        }
        StringReader sr = new StringReader(stringPair);
        StringBuilder first = new StringBuilder();
        StringBuilder second = new StringBuilder();
        try {
            int comma = Csv.readCsvElement(sr, first);
            if (comma != 44) {
                return null;
            }
            int last = Csv.readCsvElement(sr, second);
            if (last >= 0) {
                return null;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return Pair.of(first.toString(), second.toString());
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (!(this.first == other.first || this.first != null && this.first.equals(other.first))) {
            return false;
        }
        return this.second == other.second || this.second != null && this.second.equals(other.second);
    }

    @Override
    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.first, this.second});
    }

    public final String toString() {
        StringBuilder result = new StringBuilder(32);
        this.writeTo(result);
        return result.toString();
    }

    @Override
    public final void writeTo(Appendable appendable) throws IOException {
        Csv.writeCsvElement(this.first == null ? "" : this.first.toString(), appendable);
        appendable.append(',');
        Csv.writeCsvElement(this.second == null ? "" : this.second.toString(), appendable);
    }

    public final List<Object> toList() {
        return Arrays.asList(this.first, this.second);
    }

    public static <K, V> Map<K, V> asMap(Pair<K, ? extends V> ... pairs) {
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(pairs.length);
        for (Pair<K, V> pair : pairs) {
            result.put(pair.getFirst(), pair.getSecond());
        }
        return result;
    }

    @Override
    public final A getKey() {
        return this.first;
    }

    @Override
    public final B getValue() {
        return this.second;
    }

    @Override
    public final B setValue(B value) {
        throw new UnsupportedOperationException("Object not mutable");
    }
}

