/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Arrays;
import org.spf4j.base.Reflections;
import org.spf4j.base.SysExits;
import org.spf4j.base.Throwables;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.UIDGenerator;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.os.OperatingSystem;
import org.spf4j.os.ProcessHandler;
import org.spf4j.os.ProcessResponse;
import org.spf4j.recyclable.impl.ArraySuppliers;
import org.spf4j.stackmonitor.FastStackCollector;
import org.spf4j.unix.JVMArguments;
import org.spf4j.unix.Lsof;
import org.spf4j.unix.UnixRuntime;

public final class Runtime {
    public static final boolean IS_LITTLE_ENDIAN;
    public static final int WAIT_FOR_SHUTDOWN_MILLIS;
    public static final String TMP_FOLDER;
    public static final String JAVA_VERSION;
    public static final String USER_NAME;
    public static final String USER_DIR;
    public static final String USER_HOME;
    public static final String JAVA_HOME;
    private static final SortedMap<Integer, Set<Runnable>> SHUTDOWN_HOOKS;
    public static final ThreadLocal<Long> DEADLINE;
    public static final int PID;
    public static final String OS_NAME;
    public static final String PROCESS_NAME;
    public static final String PROCESS_ID;
    public static final int NR_PROCESSORS;
    private static final boolean IS_MAC_OSX;
    private static final boolean IS_WINDOWS;
    public static final Version JAVA_PLATFORM;
    private static final List<Class<?>> PRELOADED;

    private Runtime() {
    }

    public static void goDownWithError(SysExits exitCode) {
        Runtime.goDownWithError(null, exitCode.exitCode());
    }

    public static void goDownWithError(@Nullable Throwable t, SysExits exitCode) {
        Runtime.goDownWithError(t, exitCode.exitCode());
    }

    @SuppressFBWarnings(value={"MDM_RUNTIME_EXIT_OR_HALT"})
    public static void goDownWithError(@Nullable Throwable t, int exitCode) {
        try {
            if (t != null) {
                Throwables.writeTo(t, System.err, Throwables.PackageDetail.NONE);
                Throwables.writeTo(t, System.err, Throwables.PackageDetail.SHORT);
                Lazy.LOGGER.error("Error, going down with exit code {}", (Object)exitCode, (Object)t);
            } else {
                Lazy.LOGGER.error("Error, going down with exit code {}", (Object)exitCode);
            }
        }
        finally {
            java.lang.Runtime.getRuntime().halt(exitCode);
        }
    }

    public static boolean isMacOsx() {
        return IS_MAC_OSX;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isTestFramework() {
        StackTraceElement[][] stackTraces;
        for (StackTraceElement[] sts : stackTraces = FastStackCollector.getStackTraces(FastStackCollector.getThreads())) {
            if (sts == null) continue;
            for (StackTraceElement ste : sts) {
                String className = ste.getClassName();
                if (!className.startsWith("org.junit") && !className.startsWith("org.openjdk.jmh")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean haveJnaPlatform() {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("com/sun/jna/platform/package.html");
        return resource != null;
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_RETURN_FALSE"})
    public static boolean haveJnaPlatformClib() {
        try {
            Class.forName("com.sun.jna.platform.unix.LibC");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @CheckReturnValue
    @Deprecated
    public static int getNrOpenFiles() {
        return (int)OperatingSystem.getOpenFileDescriptorCount();
    }

    @Nullable
    @CheckReturnValue
    @Deprecated
    public static CharSequence getLsofOutput() {
        return Lsof.getLsofOutput();
    }

    @Deprecated
    public static CharSequence run(String[] command, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        return OperatingSystem.forkExec(command, timeoutMillis);
    }

    @Deprecated
    public static int killProcess(Process proc, long terminateTimeoutMillis, long forceTerminateTimeoutMillis) throws InterruptedException {
        return OperatingSystem.killProcess(proc, terminateTimeoutMillis, forceTerminateTimeoutMillis);
    }

    public static int run(String[] command, ProcOutputHandler handler, long timeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        return Runtime.run(command, handler, timeoutMillis, 60000L);
    }

    @Deprecated
    @SuppressFBWarnings(value={"COMMAND_INJECTION"})
    public static int run(String[] command, final ProcOutputHandler handler, long timeoutMillis, long terminationTimeoutMillis) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        ProcessResponse<Void, Void> resp = OperatingSystem.forkExec(command, new ProcessHandler<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void handleStdOut(InputStream is) throws IOException {
                byte[] buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(8192);
                try {
                    int cos;
                    while ((cos = is.read(buffer)) >= 0) {
                        handler.handleStdOut(buffer, cos);
                    }
                }
                finally {
                    ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
                    handler.stdOutDone();
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void handleStdErr(InputStream stderr) throws IOException {
                byte[] buffer = ArraySuppliers.Bytes.TL_SUPPLIER.get(8192);
                try {
                    int cos;
                    while ((cos = stderr.read(buffer)) >= 0) {
                        handler.handleStdErr(buffer, cos);
                    }
                }
                finally {
                    ArraySuppliers.Bytes.TL_SUPPLIER.recycle(buffer);
                    handler.stdErrDone();
                }
                return null;
            }
        }, timeoutMillis, terminationTimeoutMillis);
        return resp.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueHookAtBeginning(Runnable runnable) {
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            Runtime.queueHook(Integer.MIN_VALUE, runnable);
        }
    }

    public static void queueHookAtEnd(Runnable runnable) {
        Runtime.queueHook(Integer.MAX_VALUE, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueHook(int priority, Runnable runnable) {
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            Integer pr = priority;
            HashSet<Runnable> runnables = (HashSet<Runnable>)SHUTDOWN_HOOKS.get(pr);
            if (runnables == null) {
                runnables = new HashSet<Runnable>();
                SHUTDOWN_HOOKS.put(pr, runnables);
            }
            runnables.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeQueuedShutdownHook(Runnable runnable) {
        if ("spf4j queued shutdown".equals(Thread.currentThread().getName())) {
            return false;
        }
        SortedMap<Integer, Set<Runnable>> sortedMap = SHUTDOWN_HOOKS;
        synchronized (sortedMap) {
            for (Set<Runnable> entry : SHUTDOWN_HOOKS.values()) {
                if (!entry.remove(runnable)) continue;
                return true;
            }
        }
        return false;
    }

    public static long getDeadline() {
        return DEADLINE.get();
    }

    public static long millisToDeadline() throws TimeoutException {
        long deadline = DEADLINE.get();
        long result = deadline - System.currentTimeMillis();
        if (result < 0L) {
            throw new TimeoutException("Deadline passed " + ISODateTimeFormat.basicDateTime().print(deadline));
        }
        return result;
    }

    public static void setDeadline(long deadline) {
        DEADLINE.set(deadline);
    }

    @SuppressFBWarnings
    public static boolean gc(long timeoutMillis) {
        WeakReference<Object> ref = new WeakReference<Object>(new Object());
        long deadline = System.currentTimeMillis() + timeoutMillis;
        do {
            System.gc();
        } while (ref.get() != null && System.currentTimeMillis() < deadline);
        return ref.get() == null;
    }

    public static CharSequence jrun(Class<?> classWithMain, long timeoutMillis, String ... arguments) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
        return Runtime.jrun(classWithMain, classPath, timeoutMillis, arguments);
    }

    public static CharSequence jrun(Class<?> classWithMain, String classPath, long timeoutMillis, String ... arguments) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        JVMArguments inputArguments = new JVMArguments(ManagementFactory.getRuntimeMXBean().getInputArguments());
        inputArguments.removeAllSystemPropertiesStartingWith("com.sun.management.jmxremote");
        return Runtime.jrun(classWithMain, classPath, timeoutMillis, inputArguments.toArray(), arguments);
    }

    public static CharSequence jrun(Class<?> classWithMain, String classPath, long timeoutMillis, String[] jvmArgs, String ... arguments) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        String jvmPath = JAVA_HOME + File.separatorChar + "bin" + File.separatorChar + "java";
        String[] command = Arrays.concat({jvmPath}, jvmArgs, {"-cp", classPath, classWithMain.getName()}, arguments);
        return OperatingSystem.forkExec(command, timeoutMillis);
    }

    @Nullable
    public static Thread getMainThread() {
        Thread[] threads;
        for (Thread t : threads = FastStackCollector.getThreads()) {
            if (t.getId() != 1L) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static Class<?> getMainClass() {
        Thread mainThread = Runtime.getMainThread();
        if (mainThread == null) {
            return null;
        }
        StackTraceElement[] stackTrace = mainThread.getStackTrace();
        if (stackTrace.length == 0) {
            return null;
        }
        String className = stackTrace[stackTrace.length - 1].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            NoClassDefFoundError tex = new NoClassDefFoundError("Cannot find " + className);
            tex.initCause(ex);
            throw tex;
        }
    }

    static {
        String osName;
        String mxBeanName;
        IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
        WAIT_FOR_SHUTDOWN_MILLIS = Integer.getInteger("spf4j.waitForShutdownMillis", 30000);
        TMP_FOLDER = System.getProperty("java.io.tmpdir");
        JAVA_VERSION = System.getProperty("java.version");
        USER_NAME = System.getProperty("user.name");
        USER_DIR = System.getProperty("user.dir");
        USER_HOME = System.getProperty("user.home");
        JAVA_HOME = System.getProperty("java.home");
        SHUTDOWN_HOOKS = new TreeMap<Integer, Set<Runnable>>();
        DEADLINE = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return Long.MAX_VALUE;
            }
        };
        PRELOADED = new ArrayList(2);
        try (PrintStream stream = new PrintStream((OutputStream)new ByteArrayBuilder(), false, "UTF-8");){
            RuntimeException rex = new RuntimeException("priming");
            Throwables.writeTo((Throwable)rex, stream, Throwables.PackageDetail.NONE);
            Throwables.containsNonRecoverable(rex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        java.lang.Runtime runtime = java.lang.Runtime.getRuntime();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        int availableProcessors = runtime.availableProcessors();
        if (availableProcessors <= 0) {
            System.err.println("Invalid number of processors " + availableProcessors + " defaulting to 1");
            NR_PROCESSORS = 1;
        } else {
            NR_PROCESSORS = availableProcessors;
        }
        PROCESS_NAME = mxBeanName = runtimeMxBean.getName();
        boolean useUIDGeneratorForJvmId = Boolean.getBoolean("spf4j.useUIDForProcessId");
        PROCESS_ID = useUIDGeneratorForJvmId ? UIDGenerator.generateIdBase("J", '-').toString() : mxBeanName + ':' + Long.toHexString((System.currentTimeMillis() - 1509741164184L) / 1000L);
        int atIdx = mxBeanName.indexOf(64);
        PID = atIdx < 0 ? -1 : Integer.parseInt(mxBeanName.substring(0, atIdx));
        OS_NAME = osName = System.getProperty("os.name");
        IS_MAC_OSX = "Mac OS X".equals(osName);
        IS_WINDOWS = osName.startsWith("Windows");
        final boolean dumpNonDaemonThreadInfoOnShutdown = Boolean.getBoolean("spf4j.dumpNonDaemonThreadInfoOnShutdown");
        if (dumpNonDaemonThreadInfoOnShutdown) {
            PRELOADED.add(FastStackCollector.class);
        }
        runtime.addShutdownHook(new Thread((Runnable)new AbstractRunnable(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void doRun() throws Exception {
                TreeMap hooks;
                Exception rex = null;
                SortedMap sortedMap = SHUTDOWN_HOOKS;
                synchronized (sortedMap) {
                    hooks = new TreeMap(SHUTDOWN_HOOKS);
                    for (Map.Entry entry : hooks.entrySet()) {
                        entry.setValue(new HashSet((Collection)entry.getValue()));
                    }
                }
                for (Map.Entry entry : hooks.entrySet()) {
                    Set set = (Set)entry.getValue();
                    if (set.size() <= 1) {
                        for (Runnable runnable : set) {
                            try {
                                runnable.run();
                            }
                            catch (RuntimeException runtimeException) {
                                if (rex == null) {
                                    rex = runtimeException;
                                    continue;
                                }
                                rex.addSuppressed(runtimeException);
                            }
                        }
                        continue;
                    }
                    if ((Integer)entry.getKey() >= Integer.MAX_VALUE) {
                        Thread[] threads = new Thread[set.size()];
                        int i = 0;
                        for (Runnable runnable : set) {
                            Thread thread = new Thread(runnable);
                            thread.start();
                            threads[i++] = thread;
                        }
                        long l = System.currentTimeMillis() + (long)WAIT_FOR_SHUTDOWN_MILLIS;
                        for (Thread thread : threads) {
                            try {
                                thread.join(l - System.currentTimeMillis());
                            }
                            catch (InterruptedException ex) {
                                if (rex == null) {
                                    rex = ex;
                                    continue;
                                }
                                rex.addSuppressed(ex);
                            }
                        }
                        continue;
                    }
                    ArrayList futures = new ArrayList(set.size());
                    for (Runnable runnable : set) {
                        futures.add(DefaultExecutor.INSTANCE.submit(runnable));
                    }
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (InterruptedException | RuntimeException | ExecutionException ex) {
                            if (rex == null) {
                                rex = ex;
                                continue;
                            }
                            rex.addSuppressed(ex);
                        }
                    }
                }
                if (dumpNonDaemonThreadInfoOnShutdown) {
                    void var8_25;
                    Thread[] threads = FastStackCollector.getThreads();
                    Thread thread = Thread.currentThread();
                    boolean bl = true;
                    Thread[] threadArray = threads;
                    int n = threadArray.length;
                    boolean bl2 = false;
                    while (var8_25 < n) {
                        Object thread2 = threadArray[var8_25];
                        if (((Thread)thread2).isAlive() && !((Thread)thread2).isDaemon() && !thread2.equals(thread) && !((Thread)thread2).getName().contains("DestroyJavaVM")) {
                            boolean bl3;
                            if (bl3) {
                                System.err.println("Non daemon threads still running:");
                                bl3 = false;
                            }
                            System.err.println("Non daemon thread " + thread2 + ", stackTrace = " + java.util.Arrays.toString(((Thread)thread2).getStackTrace()));
                        }
                        ++var8_25;
                    }
                }
                if (rex != null) {
                    throw rex;
                }
            }
        }, "spf4j queued shutdown"));
        JAVA_PLATFORM = Version.fromSpecVersion(JAVA_VERSION);
        Registry.export(Jmx.class);
    }

    public static final class Jmx {
        @JmxExport
        public static Reflections.PackageInfo getPackageInfo(@JmxExport(value="className") String className) {
            return Reflections.getPackageInfo(className);
        }

        @JmxExport
        public static void restart() throws IOException {
            UnixRuntime.restart();
        }
    }

    @Deprecated
    public static interface ProcOutputHandler {
        public void handleStdOut(byte[] var1, int var2);

        public void stdOutDone();

        public void handleStdErr(byte[] var1, int var2);

        public void stdErrDone();
    }

    private static class Lazy {
        private static final Logger LOGGER = LoggerFactory.getLogger(Lazy.class);

        private Lazy() {
        }
    }

    public static enum Version {
        V1_0,
        V1_1,
        V1_2,
        V1_3,
        V1_4,
        V1_5,
        V1_6,
        V1_7,
        V1_8,
        V1_9_PLUSZ;


        public static Version fromSpecVersion(String specVersion) {
            return Version.values()[Integer.parseInt(specVersion.split("\\.")[1])];
        }
    }
}

