/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AggregateTranslator;
import org.spf4j.base.Arrays;
import org.spf4j.base.CharSequenceTranslator;
import org.spf4j.base.CharSequences;
import org.spf4j.base.LookupTranslator;
import org.spf4j.base.OctalUnescaper;
import org.spf4j.base.TLScratch;
import org.spf4j.base.UnicodeUnescaper;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;

@SuppressFBWarnings(value={"IICU_INCORRECT_INTERNAL_CLASS_USE"})
public final class Strings {
    private static final Logger LOG = LoggerFactory.getLogger(Strings.class);
    private static final MethodHandle CHARS_FIELD_GET;
    private static final MethodHandle PROTECTED_STR_CONSTR_HANDLE;
    private static final Class<?>[] PROTECTED_STR_CONSTR_PARAM_TYPES;
    public static final String EOL;
    private static final String[][] JAVA_CTRL_CHARS_UNESCAPE;
    private static final CharSequenceTranslator UNESCAPE_JAVA;
    private static final char[] DIGITS;
    private static final ThreadLocal<char[]> BUFF;
    private static final boolean LENIENT_CODING;
    private static final ThreadLocal<CharsetDecoder> UTF8_DECODER;
    private static final ThreadLocal<CharsetEncoder> UTF8_ENCODER;

    private Strings() {
    }

    @Deprecated
    public static int distance(@Nonnull String s1, @Nonnull String s2) {
        return CharSequences.distance(s1, s2);
    }

    public static String unescape(String what) {
        return UNESCAPE_JAVA.translate(what);
    }

    public static boolean contains(String string, char ... chars) {
        for (char c : chars) {
            if (string.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean contains(CharSequence string, char ... chars) {
        return CharSequences.containsAnyChar(string, chars);
    }

    public static String withFirstCharLower(String str) {
        if (str.isEmpty()) {
            return str;
        }
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        int l = str.length();
        StringBuilder result = new StringBuilder(l);
        result.append(Character.toLowerCase(str.charAt(0)));
        for (int i = 1; i < l; ++i) {
            result.append(str.charAt(i));
        }
        return result.toString();
    }

    public static void writeReplaceWhitespaces(String str, char replacement, Appendable writer) throws IOException {
        for (char c : Strings.steal(str)) {
            if (Character.isWhitespace(c)) {
                writer.append(replacement);
                continue;
            }
            writer.append(c);
        }
    }

    public static char[] steal(String str) {
        if (CHARS_FIELD_GET == null) {
            return str.toCharArray();
        }
        try {
            return CHARS_FIELD_GET.invokeExact(str);
        }
        catch (Throwable ex) {
            UnknownError err = new UnknownError("Error while stealing String char array");
            err.addSuppressed(ex);
            throw err;
        }
    }

    public static String wrap(char[] chars) {
        if (PROTECTED_STR_CONSTR_PARAM_TYPES != null) {
            try {
                if (PROTECTED_STR_CONSTR_PARAM_TYPES.length == 3) {
                    return PROTECTED_STR_CONSTR_HANDLE.invokeExact(0, chars.length, chars);
                }
                return PROTECTED_STR_CONSTR_HANDLE.invokeExact(chars, true);
            }
            catch (Throwable ex) {
                UnknownError err = new UnknownError("Error while wrapping String char array");
                err.addSuppressed(ex);
                throw err;
            }
        }
        return new String(chars);
    }

    public static CharsetEncoder createUtf8Encoder() {
        if (LENIENT_CODING) {
            return StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public static CharsetDecoder createUtf8Decoder() {
        if (LENIENT_CODING) {
            return StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public static CharsetEncoder getUTF8CharsetEncoder() {
        return UTF8_ENCODER.get();
    }

    public static CharsetDecoder getUTF8CharsetDecoder() {
        return UTF8_DECODER.get();
    }

    @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
    public static byte[] encode(CharsetEncoder ce, char[] ca, int off, int len) {
        if (len == 0) {
            return Arrays.EMPTY_BYTE_ARRAY;
        }
        byte[] ba = TLScratch.getBytesTmp(Strings.getmaxNrBytes(ce, len));
        int nrBytes = Strings.encode(ce, ca, off, len, ba);
        return java.util.Arrays.copyOf(ba, nrBytes);
    }

    public static int getmaxNrBytes(CharsetEncoder ce, int nrChars) {
        return (int)((double)nrChars * (double)ce.maxBytesPerChar());
    }

    public static int encode(CharsetEncoder ce, char[] ca, int off, int len, byte[] targetArray) {
        if (len == 0) {
            return 0;
        }
        if (ce instanceof ArrayEncoder) {
            return ((ArrayEncoder)((Object)ce)).encode(ca, off, len, targetArray);
        }
        ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(targetArray);
        CharBuffer cb = CharBuffer.wrap(ca, off, len);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new InternalError("Should never throw a CharacterCodingException, probably a JVM issue", x);
        }
        return bb.position();
    }

    @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
    public static String decode(CharsetDecoder cd, byte[] ba, int off, int len) {
        if (len == 0) {
            return "";
        }
        int en = (int)((double)len * (double)cd.maxCharsPerByte());
        char[] ca = TLScratch.getCharsTmp(en);
        if (cd instanceof ArrayDecoder) {
            int clen = ((ArrayDecoder)((Object)cd)).decode(ba, off, len, ca);
            return new String(ca, 0, clen);
        }
        cd.reset();
        ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
        CharBuffer cb = CharBuffer.wrap(ca);
        try {
            CoderResult cr = cd.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = cd.flush(cb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return new String(ca, 0, cb.position());
    }

    public static String fromUtf8(byte[] bytes) {
        return Strings.decode(UTF8_DECODER.get(), bytes, 0, bytes.length);
    }

    public static String fromUtf8(byte[] bytes, int startIdx, int length) {
        return Strings.decode(UTF8_DECODER.get(), bytes, startIdx, length);
    }

    public static byte[] toUtf8(String str) {
        char[] chars = Strings.steal(str);
        return Strings.encode(UTF8_ENCODER.get(), chars, 0, chars.length);
    }

    @Deprecated
    public static int compareTo(@Nonnull CharSequence s, @Nonnull CharSequence t) {
        return CharSequences.compareTo(s, t);
    }

    @Deprecated
    public static boolean equals(@Nonnull CharSequence s, @Nonnull CharSequence t) {
        return CharSequences.equals(s, t);
    }

    @Deprecated
    public static int hashcode(CharSequence cs) {
        return CharSequences.hashcode(cs);
    }

    @Deprecated
    public static CharSequence subSequence(CharSequence seq, int startIdx, int endIdx) {
        return CharSequences.subSequence(seq, startIdx, endIdx);
    }

    @Deprecated
    public static boolean endsWith(CharSequence qc, CharSequence with) {
        return CharSequences.endsWith(qc, with);
    }

    public static void escapeJsonString(@Nonnull String toEscape, StringBuilder jsonString) {
        int len = toEscape.length();
        for (int i = 0; i < len; ++i) {
            char c = toEscape.charAt(i);
            Strings.appendJsonStringEscapedChar(c, jsonString);
        }
    }

    public static void escapeJsonString(@Nonnull String toEscape, Appendable jsonString) throws IOException {
        int len = toEscape.length();
        for (int i = 0; i < len; ++i) {
            char c = toEscape.charAt(i);
            Strings.appendJsonStringEscapedChar(c, jsonString);
        }
    }

    public static void appendJsonStringEscapedChar(char c, StringBuilder jsonString) {
        switch (c) {
            case '\"': 
            case '\\': {
                jsonString.append('\\');
                jsonString.append(c);
                break;
            }
            case '\b': {
                jsonString.append("\\b");
                break;
            }
            case '\t': {
                jsonString.append("\\t");
                break;
            }
            case '\n': {
                jsonString.append("\\n");
                break;
            }
            case '\f': {
                jsonString.append("\\f");
                break;
            }
            case '\r': {
                jsonString.append("\\r");
                break;
            }
            default: {
                if (c < ' ') {
                    jsonString.append("\\u");
                    Strings.appendUnsignedStringPadded(jsonString, (int)c, 4, 4);
                    break;
                }
                jsonString.append(c);
            }
        }
    }

    public static void appendJsonStringEscapedChar(char c, Appendable jsonString) throws IOException {
        switch (c) {
            case '\"': 
            case '\\': {
                jsonString.append('\\');
                jsonString.append(c);
                break;
            }
            case '\b': {
                jsonString.append("\\b");
                break;
            }
            case '\t': {
                jsonString.append("\\t");
                break;
            }
            case '\n': {
                jsonString.append("\\n");
                break;
            }
            case '\f': {
                jsonString.append("\\f");
                break;
            }
            case '\r': {
                jsonString.append("\\r");
                break;
            }
            default: {
                if (c < ' ') {
                    jsonString.append("\\u");
                    Strings.appendUnsignedStringPadded(jsonString, (int)c, 4, 4);
                    break;
                }
                jsonString.append(c);
            }
        }
    }

    public static void appendUnsignedString(StringBuilder sb, long nr, int shift) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        sb.append(buf, charPos, 64 - charPos);
    }

    public static void appendUnsignedString(StringBuilder sb, int nr, int shift) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        sb.append(buf, charPos, 32 - charPos);
    }

    public static void appendUnsignedStringPadded(StringBuilder sb, int nr, int shift, int padTo) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        int nrChars = 32 - charPos;
        if (nrChars > padTo) {
            throw new IllegalArgumentException("Your pad to value " + padTo + " is to small, must be at least " + nrChars);
        }
        int n = padTo - nrChars;
        for (int j = 0; j < n; ++j) {
            sb.append('0');
        }
        sb.append(buf, charPos, nrChars);
    }

    public static void appendUnsignedStringPadded(Appendable sb, int nr, int shift, int padTo) throws IOException {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        int nrChars = 32 - charPos;
        if (nrChars > padTo) {
            throw new IllegalArgumentException("Your pad to value " + padTo + " is to small, must be at least " + nrChars);
        }
        int n = padTo - nrChars;
        for (int j = 0; j < n; ++j) {
            sb.append('0');
        }
        sb.append(CharBuffer.wrap(buf), charPos, charPos + nrChars);
    }

    public static void appendSpaces(Appendable to, int nrSpaces) throws IOException {
        for (int i = 0; i < nrSpaces; ++i) {
            to.append(' ');
        }
    }

    public static void appendSpaces(StringBuilder to, int nrSpaces) {
        for (int i = 0; i < nrSpaces; ++i) {
            to.append(' ');
        }
    }

    @Deprecated
    public static boolean regionMatches(CharSequence t, int toffset, CharSequence other, int ooffset, int plen) {
        return CharSequences.regionMatches(t, toffset, other, ooffset, plen);
    }

    public static String truncate(@Nonnull String value, int length) {
        if (value.length() > length) {
            return value.substring(0, length);
        }
        return value;
    }

    @Nonnull
    public static String commonPrefix(String ... strs) {
        Preconditions.checkArgument((strs.length > 0 ? 1 : 0) != 0, (String)"Must have at least 1 string %s", (Object[])strs);
        String common = strs[0];
        for (int i = 1; i < strs.length; ++i) {
            common = com.google.common.base.Strings.commonPrefix((CharSequence)common, (CharSequence)strs[i]);
        }
        return common;
    }

    static {
        EOL = System.getProperty("line.separator", "\n");
        JAVA_CTRL_CHARS_UNESCAPE = new String[][]{{"\\b", "\b"}, {"\\n", "\n"}, {"\\t", "\t"}, {"\\f", "\f"}, {"\\r", "\r"}};
        UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(JAVA_CTRL_CHARS_UNESCAPE), new LookupTranslator({"\\\\", "\\"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\", ""}));
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        BUFF = new ThreadLocal<char[]>(){

            @Override
            @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
            protected char[] initialValue() {
                return new char[64];
            }
        };
        LENIENT_CODING = Boolean.getBoolean("spf4j.encoding.lenient");
        UTF8_DECODER = new ThreadLocal<CharsetDecoder>(){

            @Override
            protected CharsetDecoder initialValue() {
                return Strings.createUtf8Decoder();
            }
        };
        UTF8_ENCODER = new ThreadLocal<CharsetEncoder>(){

            @Override
            protected CharsetEncoder initialValue() {
                return Strings.createUtf8Encoder();
            }
        };
        Field charsField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Field charsField;
                try {
                    charsField = String.class.getDeclaredField("value");
                    charsField.setAccessible(true);
                }
                catch (NoSuchFieldException ex) {
                    LOG.info("char array stealing from String not supported", (Throwable)ex);
                    charsField = null;
                }
                return charsField;
            }
        });
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (charsField != null) {
            try {
                CHARS_FIELD_GET = lookup.unreflectGetter(charsField);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        } else {
            CHARS_FIELD_GET = null;
        }
        Constructor<String> prConstr = AccessController.doPrivileged(new PrivilegedAction<Constructor<String>>(){

            @Override
            public Constructor<String> run() {
                Constructor<String> constr;
                try {
                    constr = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                    constr.setAccessible(true);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        constr = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
                        constr.setAccessible(true);
                    }
                    catch (NoSuchMethodException ex2) {
                        ex2.addSuppressed(ex);
                        LOG.info("building String from char[] fast not supported", (Throwable)ex2);
                        constr = null;
                    }
                }
                return constr;
            }
        });
        if (prConstr == null) {
            PROTECTED_STR_CONSTR_PARAM_TYPES = null;
            PROTECTED_STR_CONSTR_HANDLE = null;
        } else {
            PROTECTED_STR_CONSTR_PARAM_TYPES = prConstr.getParameterTypes();
            try {
                PROTECTED_STR_CONSTR_HANDLE = lookup.unreflectConstructor(prConstr);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }
}

