/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.lang.ref.SoftReference;

public final class TLScratch {
    private static final ThreadLocal<SoftReference<byte[]>> BYTES_TMP = new ThreadLocal();
    private static final ThreadLocal<SoftReference<char[]>> CHARS_TMP = new ThreadLocal();

    private TLScratch() {
    }

    public static byte[] getBytesTmp(int size) {
        byte[] result;
        SoftReference<byte[]> sr = BYTES_TMP.get();
        if (sr == null) {
            result = new byte[size];
            BYTES_TMP.set(new SoftReference<byte[]>(result));
        } else {
            result = sr.get();
            if (result == null || result.length < size) {
                result = new byte[size];
                BYTES_TMP.set(new SoftReference<byte[]>(result));
            }
        }
        return result;
    }

    public static char[] getCharsTmp(int size) {
        char[] result;
        SoftReference<char[]> sr = CHARS_TMP.get();
        if (sr == null) {
            result = new char[size];
            CHARS_TMP.set(new SoftReference<char[]>(result));
        } else {
            result = sr.get();
            if (result == null || result.length < size) {
                result = new char[size];
                CHARS_TMP.set(new SoftReference<char[]>(result));
            }
        }
        return result;
    }
}

