/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.Beta;
import java.util.concurrent.TimeUnit;
import org.spf4j.concurrent.DefaultScheduler;

@Beta
public final class Timing {
    private static final long TIMING_UPDATE_INTERVAL_MINUTES = Long.getLong("spf4j.timing.updateIntervalMinutes", 60L);
    private static volatile Timing latestTiming = new Timing();
    private final long nanoTimeRef = System.nanoTime();
    private final long currentTimeMillisRef = System.currentTimeMillis();

    private Timing() {
    }

    public long fromNanoTimeToEpochMillis(long nanoTime) {
        return this.currentTimeMillisRef + TimeUnit.NANOSECONDS.toMillis(nanoTime - this.nanoTimeRef);
    }

    public static Timing getCurrentTiming() {
        return latestTiming;
    }

    public String toString() {
        return "Timing{nanoTimeRef=" + this.nanoTimeRef + ", currentTimeMillisRef=" + this.currentTimeMillisRef + '}';
    }

    static {
        DefaultScheduler.INSTANCE.scheduleWithFixedDelay(() -> {
            latestTiming = new Timing();
        }, TIMING_UPDATE_INTERVAL_MINUTES, TIMING_UPDATE_INTERVAL_MINUTES, TimeUnit.MINUTES);
    }
}

